#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12623);
 script_bugtraq_id(9764);
 script_version ("$Revision: 1.4 $");
 script_cve_id("CAN-2004-0149");
 name["english"] = "FreeBSD Ports : xboing < 2.4.2";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the xboing package installed.

xboing is an X11 arcade game. The remote version of this software contains 
several buffer overflows which may allow a local user to elevate his privileges
to the 'games' gid.

Solution : http://www.vuxml.org/freebsd/e25566d5-6d3f-11d8-83a4-000a95bc6fae.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the xboing package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^xboing-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"xboing-2.4_2") < 0 ) 
	security_warning(0);
