#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15505);
 script_version ("$Revision: 1.1 $");
 name["english"] = "FreeBSD Ports : wordpress < 1.2.1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has the following package installed :
	wordpress < 1.2.1

wordpress is a blob manager written in PHP.

The remote version of this software is vulnerable to a cross site scripting
attack in the administration panel.

Solution : http://www.vuxml.org/freebsd/12b7b4cf-1d53-11d9-814e-0001020eed82.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the wordpress package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^wordpress-[01]", string:pkgs);
if (package && pkg_cmp(pkg:package, reference:"wordpress-1.2.1") < 0 )
	security_warning(0);
