#
# (C) Tenable Network Security
#
#
if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14297);
 script_bugtraq_id(10967);
 #script_cve_id("");
 script_version ("$Revision: 1.2 $");

 name["english"] = "FreeBSD tnftpd vulnerability";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running an older version of Tnftpd.

Tnftpd is an FTP server which runs on Unix systems.  Tnftpd
is shipped with at least one version, 4.7, of FreeBSD.

This version of tnftpd is vulnerable multiple remote exploits
which will give a remote attacker full access to the underlying
file system or root-level access (i.e. remote shell).  

Solution : http://www.vuxml.org/freebsd/c4b025bb-f05d-11d8-9837-000c41e2cdad.html 

See also : http://freshmeat.net/projects/tnftpd
 
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "FreeBSD tnftpd multiple remote exploits";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
package = egrep(pattern:"^tnftpd-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"tnftpd-20040810") < 0 )
        security_hole(0);


