#
# (C) Tenable Network Security
#
# The plugin description is (C) Jacques Vidrine and contributors. 
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15811);
 script_version ("$Revision: 1.1 $");
 script_cve_id ("CAN-2004-0930");
 name["english"] = "FreeBSD Ports : samba < 3.0.8,1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has one of the following packages installed :

3 <= samba < 3.0.8,1

A remote attacker could cause an smbd process to consume  abnormal amounts of 
system resources due to an input  validation error when matching filenames 
containing wildcard characters.

See also : http://us4.samba.org/samba/security/CAN-2004-0930.html
Solution : http://www.vuxml.org/freebsd/ba13dc13-340d-11d9-ac1b-000d614f7fad.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the samba package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^samba-3\.", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"samba-3.0.8,1") < 0  )
	{
	security_hole(0);
	exit(0);
	}
