#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12606);
 script_bugtraq_id(1242);
 script_version ("$Revision: 1.5 $");
 script_cve_id("CVE-2000-0442");
 name["english"] = "FreeBSD Ports : qpopper <= 2.53_1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the qpopper package installed.

qpopper is a POP3 server. There is a format string vulnerability in the remote
version of qpopper which may allow an authenticated user to execute arbitrary
code with the privileges of group id 'mail'.

Solution : http://www.vuxml.org/freebsd/ebdf65c7-2ca6-11d8-9355-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the qpopper package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^qpopper", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"qpopper-2.53_1") < 0 ) 
	security_hole(0);
