#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14759);
 script_version ("$Revision: 1.2 $");
 script_bugtraq_id(11151);
 script_cve_id("CAN-2004-0752");
 name["english"] = "FreeBSD Ports : OpenOffice.org < 1.1.2_1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of the openoffice package which is older
than openoffice-1.1.2_1.


There is bug in the remote version of this software which makes it create
a working directory in /tmp on startup to use it to store documents contents
with weak permissions.

This problem may allow a local attacker to snoop on other users's files.

Solution : http://www.vuxml.org/freebsd/c62dc69f-05c8-11d9-b45d-000c41e2cdad.html
Risk factor : Low";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the openoffice package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^openoffice-[0-9]", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"openoffice-1.1.2_1") < 0 ) 
	security_warning(0);
