#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14756);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CAN-2004-0757");
 name["english"] = "FreeBSD Ports : Mozilla < 1.7.2";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the mozilla, linux-mozilla, netscape7
or thunderbird package installed.

These packages include a mail user agent which contains a flaw in its POP
implementation. An attacker may exploit it to cause a buffer overflow in
the process and therefore execute arbitrary commands on the remote host.

To exploit this flaw, an attacker would need to take the control of the POP
server used by a user on the remote host.

Solution : http://www.vuxml.org/freebsd/c1d97a8b-05ed-11d9-b45d-000c41e2cdad.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mozilla packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^mozilla-1", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"mozilla-1.7,2") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
package = egrep(pattern:"^linux-mozilla-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"linux-mozilla-1.7") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
package = egrep(pattern:"^netscape7-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"netscape7-7.2") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
package = egrep(pattern:"^thunderbird-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"thunderbird-0.7") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
