#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12572);
 script_bugtraq_id(10242);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0226", "CAN-2004-0231", "CAN-2004-0232");
 name["english"] = "FreeBSD Ports: mc < 4.6.0_10";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of mc installed.

mc (Midnight Commander) is a text-based file manager. There are multiple
issues in this version of this software (buffer overflows, insecure temporary
file handling and format string issues) which may be exploited by a local
attacker to escalate his privileges.

Solution : http://www.vuxml.org/freebsd/0c6f3fde-9c51-11d8-9366-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mc package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^mc-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"mc-4.6.0_10") < 0 ) security_hole(0);
