#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15496);
 script_bugtraq_id(11349);
 script_version ("$Revision: 1.1 $");
 name["english"] = "FreeBSD Ports : mail-notification < 0.7.0";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has a version of the 'mail-notification' package which is 
older than version 0.7.0.

mail-notification is a program for the GNOME 2.0 system tray.

There is a denial of service condition in the remote version of this software
which may allow an attacker to cause a null pointer dereference remotely.


Solution : http://www.vuxml.org/freebsd/3030ae22-1c7f-11d9-81a4-0050fc56d258.html
Risk factor : Low";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mail-notification package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");

pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^mail-notification-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"mail-notification-0.7.0") < 0 ) 
        {
        security_note(0);
        exit(0);
        }
