#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12561);
 script_bugtraq_id(10243, 10354);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0234", "CAN-2004-0235");
 name["english"] = "FreeBSD Ports : lha < 1.14i_4";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the LHA package which is older
than 1.14i_4.

LHA is an archiving and compression utility for LHarc format archives.

There is a couple of stack overflows and directory traversal flaws in the
remote LHA utility. An attacker could exploit these to execute arbitrary
code on this host by sending a carefully crafter LHA archive to a user of the
remote host and wait for him to uncompress the archive.


Solution : http://www.vuxml.org/freebsd/a2ffb627-9c53-11d8-9366-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the lha package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^lha-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"lha-1.14i_4") < 0 ) 
	security_hole(0);
