#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12560);
 script_bugtraq_id(9210);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0963");
 name["english"] = "FreeBSD Ports : lftp <= 2.6.10";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the lftp package which is older
than 2.6.10_1.

lftp is a shell-like command-line ftp and http client. There is a bug
in the remote version of this software which may allow an attacker to
execute arbitrary code on this host.

To exploit this flaw, an attacker would need to set up a rogue web site
answering with specially crafted replies to directory listing requests, and
would need to lure a lftp user of the remote host into visiting it.

Solution : http://www.vuxml.org/freebsd/d7af61c8-2cc0-11d8-9355-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the lftp package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^lftp", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"lftp-2.6.10_1") < 0 ) 
	security_hole(0);
