#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15499);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CAN-2004-0923");
 name["english"] = "FreeBSD Ports : CUPS < 1.1.22";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has the following package installed :
	cups-base < 1.1.22


CUPS is the 'Common UNIX Printing System', a replacement for lpr.

The remote version of this software is vulnerable to a flaw which may make
it disclose usernames and passwords in its log files which are, by default,
readable by any local user.

Solution : http://www.vuxml.org/freebsd/30cea6be-1d0c-11d9-814e-0001020eed82.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the cups-base package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^cups-base-[0-9]", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"cups-base-1.1.22.0") < 0 ) 
	{
	security_warning(0);
	exit(0);
	}
