#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15525);
 script_bugtraq_id(11460);
 script_version ("$Revision: 1.2 $");
 name["english"] = "FreeBSD Ports : cabextract < 1.1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has the following package installed :
	cabextract < 1.1

cabextract is a command-line utility to extract cabinet (.cab) archive files.

The remote version of this software is vulnerable to a directory traversal
flaw which may allow an attacker to overwrite arbitrary files on the
remote host. To exploit this flaw, an attacker would need to craft a malicious
.cab archive and send it to a victim on the remote host.

Solution : http://www.vuxml.org/freebsd/61480a9a-22b2-11d9-814e-0001020eed82.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the cabextract package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^cabextract-[01]", string:pkgs);
if (package && pkg_cmp(pkg:package, reference:"cabextract-1.1") < 0 )
	security_warning(0);
