/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editpolicies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editpolicies.ConstrainedLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public abstract class XYLayoutEditPolicy
extends ConstrainedLayoutEditPolicy {
    private static final Dimension DEFAULT_SIZE = new Dimension(-1, -1);
    private XYLayout xyLayout;

    protected Object getConstraintFor(ChangeBoundsRequest request, GraphicalEditPart child) {
        PrecisionRectangle rect = new PrecisionRectangle(child.getFigure().getBounds());
        child.getFigure().translateToAbsolute((Translatable)rect);
        Rectangle original = rect.getCopy();
        rect = request.getTransformedRectangle((Rectangle)rect);
        child.getFigure().translateToRelative((Translatable)rect);
        rect.translate(this.getLayoutOrigin().getNegated());
        if (request.getSizeDelta().width == 0 && request.getSizeDelta().height == 0) {
            Rectangle cons = this.getCurrentConstraintFor(child);
            rect.setSize(cons.width, cons.height);
        } else {
            Dimension minSize = this.getMinimumSizeFor(child);
            if (rect.width < minSize.width) {
                rect.width = minSize.width;
                if (rect.x > original.right() - minSize.width) {
                    rect.x = original.right() - minSize.width;
                }
            }
            if (rect.height < minSize.height) {
                rect.height = minSize.height;
                if (rect.y > original.bottom() - minSize.height) {
                    rect.y = original.bottom() - minSize.height;
                }
            }
        }
        return this.getConstraintFor((Rectangle)rect);
    }

    public Object getConstraintFor(Point p) {
        return new Rectangle(p, DEFAULT_SIZE);
    }

    public Object getConstraintFor(Rectangle r) {
        return new Rectangle(r);
    }

    protected Rectangle getCurrentConstraintFor(GraphicalEditPart child) {
        IFigure fig = child.getFigure();
        return (Rectangle)fig.getParent().getLayoutManager().getConstraint(fig);
    }

    protected Point getLayoutOrigin() {
        return this.getXYLayout().getOrigin(this.getLayoutContainer());
    }

    protected Dimension getMinimumSizeFor(GraphicalEditPart child) {
        return new Dimension(8, 8);
    }

    protected XYLayout getXYLayout() {
        if (this.xyLayout == null) {
            IFigure container = this.getLayoutContainer();
            this.xyLayout = (XYLayout)container.getLayoutManager();
        }
        return this.xyLayout;
    }

    public void setXyLayout(XYLayout xyLayout) {
        this.xyLayout = xyLayout;
    }

    protected void showSizeOnDropFeedback(CreateRequest request) {
        Point p = new Point(request.getLocation().getCopy());
        IFigure feedback = this.getSizeOnDropFeedback(request);
        feedback.translateToRelative((Translatable)p);
        Dimension size = request.getSize().getCopy();
        feedback.translateToRelative((Translatable)size);
        feedback.setBounds(new Rectangle(p, size).expand(this.getCreationFeedbackOffset(request)));
    }
}

