/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xml.type.internal;

import org.eclipse.emf.ecore.xml.type.InvalidDatatypeValueException;
import org.eclipse.emf.ecore.xml.type.internal.DataValue;

public final class QName {
    private String prefix;
    private String localPart;
    private String namespaceURI;

    public QName(String qname) {
        String rawname = qname;
        int index = rawname.indexOf(":");
        String prefix = "";
        String localName = rawname;
        if (index != -1) {
            prefix = rawname.substring(0, index);
            localName = rawname.substring(index + 1);
        }
        if (prefix.length() > 0 && !DataValue.XMLChar.isValidNCName(prefix)) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1: invalid QName: " + qname);
        }
        if (!DataValue.XMLChar.isValidNCName(localName)) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1: invalid QName: " + qname);
        }
        this.setPrefix(prefix);
        this.setLocalPart(localName);
        this.setNamespaceURI(null);
    }

    public QName(String namespaceURI, String localPart, String prefix) {
        this.setNamespaceURI(namespaceURI);
        this.setPrefix(prefix);
        this.setLocalPart(localPart);
        if (this.prefix.length() > 0 && !DataValue.XMLChar.isValidNCName(this.prefix)) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1: invalid QName: " + prefix);
        }
        if (!DataValue.XMLChar.isValidNCName(this.localPart)) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1: invalid QName: " + localPart);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof QName) {
            QName qname = (QName)object;
            return this.namespaceURI.equals(qname.getNamespaceURI()) && this.localPart.equals(qname.getLocalPart());
        }
        return false;
    }

    public int hashCode() {
        return this.namespaceURI.hashCode() + this.localPart.hashCode();
    }

    public String toString() {
        return this.prefix.length() > 0 ? String.valueOf(this.prefix) + ":" + this.localPart : this.localPart;
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public void setLocalPart(String localpart) {
        if (localpart == null || localpart.length() == 0) {
            throw new IllegalArgumentException("QName localPart must have value.");
        }
        this.localPart = localpart;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String namespaceUri) {
        this.namespaceURI = namespaceUri == null ? "" : namespaceUri;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix == null ? "" : prefix;
    }
}

