/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.presentation;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.domain.MappingDomain;
import org.eclipse.emf.mapping.presentation.ComposedSelection;
import org.eclipse.emf.mapping.presentation.MappingUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

class SimpleMappedObjectViewer
extends TreeViewer {
    protected SimpleMappedObjectViewer otherViewer;
    protected MappingDomain mappingDomain;
    protected AdapterFactory adapterFactory;
    protected boolean isTop;
    protected SelectObjectAction selectNextMappedObject;
    protected SelectObjectAction selectPreviousMappedObject;
    protected SelectObjectAction selectNextUnmappedObject;
    protected SelectObjectAction selectPreviousUnmappedObject;
    protected Action filterMappedObjects;
    protected Action selectOtherMappedObjects;
    protected Collection expandedObjects = new HashSet();
    protected Collection selectedObjects = new HashSet();

    public SimpleMappedObjectViewer(MappingDomain domain, Tree tree, boolean isTop) {
        super(tree);
        this.mappingDomain = domain;
        this.isTop = isTop;
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                SimpleMappedObjectViewer.this.selectOtherMappedObjects();
            }
        });
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SimpleMappedObjectViewer.this.updateActions();
            }
        });
    }

    public void setAdapterFactory(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public Action getFilterMappedObjectsAction() {
        return this.filterMappedObjects;
    }

    public void setOtherViewer(SimpleMappedObjectViewer otherViewer) {
        this.otherViewer = otherViewer;
    }

    protected ISelection doGetSelection() {
        return super.getSelection();
    }

    public void updateActions() {
        List selection = ((IStructuredSelection)this.doGetSelection()).toList();
        boolean isReady = false;
        Object previousMapped = null;
        Object previousUnmapped = null;
        Object nextMapped = null;
        Object nextUnmapped = null;
        boolean selectionHasMappings = false;
        Iterator i = ((IStructuredItemContentProvider)this.getInput()).getElements(this.getInput()).iterator();
        block0: while (i.hasNext()) {
            Object object = i.next();
            AdapterFactoryTreeIterator treeIterator = new AdapterFactoryTreeIterator(this.adapterFactory, object);
            block1: while (treeIterator.hasNext()) {
                Object child = treeIterator.next();
                if (selection.contains(child)) {
                    isReady = true;
                    if (selectionHasMappings) continue;
                    Iterator mappings = this.mappingDomain.getMappingRoot().getMappings(child).iterator();
                    while (mappings.hasNext()) {
                        Mapping mapping = (Mapping)mappings.next();
                        if ((!mapping.getInputs().contains(child) || mapping.getOutputs().isEmpty()) && (!mapping.getOutputs().contains(child) || mapping.getInputs().isEmpty())) continue;
                        selectionHasMappings = true;
                        continue block1;
                    }
                    continue;
                }
                if (this.mappingDomain.getMappingRoot().getMappings(child).isEmpty()) {
                    if (isReady) {
                        if (nextUnmapped != null) continue;
                        nextUnmapped = child;
                        if (nextMapped == null) continue;
                        break block0;
                    }
                    previousUnmapped = child;
                    continue;
                }
                if (isReady) {
                    if (nextMapped != null) continue;
                    nextMapped = child;
                    if (nextUnmapped == null) continue;
                    break block0;
                }
                previousMapped = child;
            }
        }
        this.selectNextMappedObject.setObjectToSelect(nextMapped);
        this.selectPreviousMappedObject.setObjectToSelect(previousMapped);
        this.selectNextUnmappedObject.setObjectToSelect(nextUnmapped);
        this.selectPreviousUnmappedObject.setObjectToSelect(previousUnmapped);
        this.selectOtherMappedObjects.setEnabled(selectionHasMappings);
    }

    public void selectOtherMappedObjects() {
        HashSet result = new HashSet();
        Iterator i = ((IStructuredSelection)this.doGetSelection()).iterator();
        while (i.hasNext()) {
            Mapping mapping;
            Iterator j;
            Object object = i.next();
            Collection mappings = this.mappingDomain.getMappingRoot().getMappings(object);
            if (this.mappingDomain.getMappingRoot().isInputObject(object)) {
                j = mappings.iterator();
                while (j.hasNext()) {
                    mapping = (Mapping)j.next();
                    result.addAll(mapping.getOutputs());
                }
                continue;
            }
            if (!this.mappingDomain.getMappingRoot().isOutputObject(object)) continue;
            j = mappings.iterator();
            while (j.hasNext()) {
                mapping = (Mapping)j.next();
                result.addAll(mapping.getInputs());
            }
        }
        this.otherViewer.setSelection((ISelection)new StructuredSelection(result.toArray()), true);
    }

    public ISelection getSelection() {
        ISelection basicSelection = this.doGetSelection();
        if (this.otherViewer == null) {
            return basicSelection;
        }
        return new ComposedSelection(basicSelection, new ISelection[]{basicSelection, this.otherViewer.doGetSelection()});
    }

    void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        String label = this.isTop ? "Top" : "Bottom";
        String oppositeLabel = this.isTop ? "Bottom" : "Top";
        this.selectNextMappedObject = new SelectObjectAction(MappingUIPlugin.getPlugin().getString("_UI_NextMappedObject_menu_item"), MappingUIPlugin.getPlugin().getImageDescriptor("full/elcl16/SelectNext" + label + "MappedObject"));
        this.selectNextMappedObject.setToolTipText(MappingUIPlugin.getPlugin().getString("_UI_NextMappedObject_description"));
        this.selectNextMappedObject.setHoverImageDescriptor(MappingUIPlugin.getPlugin().getImageDescriptor("full/clcl16/SelectNext" + label + "MappedObject"));
        this.selectNextMappedObject.setDisabledImageDescriptor(MappingUIPlugin.getPlugin().getImageDescriptor("full/dlcl16/SelectNext" + label + "MappedObject"));
        toolBarManager.add((IAction)this.selectNextMappedObject);
        menuManager.add((IAction)this.selectNextMappedObject);
        this.selectPreviousMappedObject = new SelectObjectAction(MappingUIPlugin.getPlugin().getString("_UI_PreviousMappedObject_menu_item"), MappingUIPlugin.getPlugin().getImageDescriptor("full/elcl16/SelectPrevious" + label + "MappedObject"));
        this.selectPreviousMappedObject.setToolTipText(MappingUIPlugin.getPlugin().getString("_UI_PreviousMappedObject_description"));
        this.selectPreviousMappedObject.setHoverImageDescriptor(MappingUIPlugin.getPlugin().getImageDescriptor("full/clcl16/SelectPrevious" + label + "MappedObject"));
        this.selectPreviousMappedObject.setDisabledImageDescriptor(MappingUIPlugin.getPlugin().getImageDescriptor("full/dlcl16/SelectPrevious" + label + "MappedObject"));
        toolBarManager.add((IAction)this.selectPreviousMappedObject);
        menuManager.add((IAction)this.selectPreviousMappedObject);
        menuManager.add((IContributionItem)new Separator());
        this.selectNextUnmappedObject = new SelectObjectAction(MappingUIPlugin.getPlugin().getString("_UI_NextUnmappedObject_menu_item"), MappingUIPlugin.getPlugin().getImageDescriptor("full/elcl16/SelectNext" + label + "UnmappedObject"));
        this.selectNextUnmappedObject.setToolTipText(MappingUIPlugin.getPlugin().getString("_UI_NextUnmappedObject_description"));
        this.selectNextUnmappedObject.setHoverImageDescriptor(MappingUIPlugin.getPlugin().getImageDescriptor("full/clcl16/SelectNext" + label + "UnmappedObject"));
        this.selectNextUnmappedObject.setDisabledImageDescriptor(MappingUIPlugin.getPlugin().getImageDescriptor("full/dlcl16/SelectNext" + label + "UnmappedObject"));
        toolBarManager.add((IAction)this.selectNextUnmappedObject);
        menuManager.add((IAction)this.selectNextUnmappedObject);
        this.selectPreviousUnmappedObject = new SelectObjectAction(MappingUIPlugin.getPlugin().getString("_UI_PreviousUnmappedObject_menu_item"), MappingUIPlugin.getPlugin().getImageDescriptor("full/elcl16/SelectPrevious" + label + "UnmappedObject"));
        this.selectPreviousUnmappedObject.setToolTipText(MappingUIPlugin.getPlugin().getString("_UI_PreviousUnmappedObject_description"));
        this.selectPreviousUnmappedObject.setHoverImageDescriptor(MappingUIPlugin.getPlugin().getImageDescriptor("full/clcl16/SelectPrevious" + label + "UnmappedObject"));
        this.selectPreviousUnmappedObject.setDisabledImageDescriptor(MappingUIPlugin.getPlugin().getImageDescriptor("full/dlcl16/SelectPrevious" + label + "UnmappedObject"));
        toolBarManager.add((IAction)this.selectPreviousUnmappedObject);
        menuManager.add((IAction)this.selectPreviousUnmappedObject);
        menuManager.add((IContributionItem)new Separator());
        this.filterMappedObjects = new Action(MappingUIPlugin.getPlugin().getString("_UI_FilterMappedObjects_menu_item"), MappingUIPlugin.getPlugin().getImageDescriptor("full/elcl16/HideAllMappedObjects")){

            public void run() {
                SimpleMappedObjectViewer.this.preserveState();
                Object input = SimpleMappedObjectViewer.this.getInput();
                SimpleMappedObjectViewer.this.setInput(input);
                SimpleMappedObjectViewer.this.restoreState();
                SimpleMappedObjectViewer.this.updateActions();
            }

            public void setChecked(boolean checked) {
                super.setChecked(checked);
                this.setToolTipText(MappingUIPlugin.getPlugin().getString(checked ? "_UI_FilterMappedObjects_checked_description" : "_UI_FilterMappedObjects_unchecked_description"));
            }
        };
        this.filterMappedObjects.setChecked(false);
        this.filterMappedObjects.setHoverImageDescriptor(MappingUIPlugin.getPlugin().getImageDescriptor("full/clcl16/HideAllMappedObjects"));
        this.filterMappedObjects.setDisabledImageDescriptor(MappingUIPlugin.getPlugin().getImageDescriptor("full/dlcl16/HideAllMappedObjects"));
        toolBarManager.add((IAction)this.filterMappedObjects);
        menuManager.add((IAction)this.filterMappedObjects);
        menuManager.add((IContributionItem)new Separator());
        this.selectOtherMappedObjects = new Action(MappingUIPlugin.getPlugin().getString("_UI_SelectOtherMappedObjects_menu_item"), MappingUIPlugin.getPlugin().getImageDescriptor("full/elcl16/Select" + oppositeLabel + "MappedObjects")){

            public void run() {
                SimpleMappedObjectViewer.this.selectOtherMappedObjects();
            }
        };
        this.selectOtherMappedObjects.setEnabled(false);
        this.selectOtherMappedObjects.setToolTipText(MappingUIPlugin.getPlugin().getString("_UI_SelectOtherMappedObjects_description"));
        this.selectOtherMappedObjects.setHoverImageDescriptor(MappingUIPlugin.getPlugin().getImageDescriptor("full/clcl16/Select" + oppositeLabel + "MappedObjects"));
        this.selectOtherMappedObjects.setDisabledImageDescriptor(MappingUIPlugin.getPlugin().getImageDescriptor("full/dlcl16/Select" + oppositeLabel + "MappedObjects"));
        toolBarManager.add((IAction)this.selectOtherMappedObjects);
        menuManager.add((IAction)this.selectOtherMappedObjects);
        toolBarManager.update(true);
        menuManager.update(true);
    }

    public void preserveState() {
        Collection oldExpandedObjects = this.expandedObjects;
        this.expandedObjects = new HashSet<Object>(Arrays.asList(this.getExpandedElements()));
        oldExpandedObjects.removeAll(this.expandedObjects);
        Iterator i = oldExpandedObjects.iterator();
        while (i.hasNext()) {
            Object oldExpandedObject = i.next();
            Widget item = this.findItem(oldExpandedObject);
            if (item != null) continue;
            this.expandedObjects.add(oldExpandedObject);
        }
        Collection oldSelectedObjects = this.selectedObjects;
        this.selectedObjects = new HashSet(((IStructuredSelection)this.getSelection()).toList());
        if (this.selectedObjects.isEmpty()) {
            this.selectedObjects = oldSelectedObjects;
        }
    }

    public void restoreState() {
        this.setExpandedElements(this.expandedObjects.toArray());
        this.setSelection((ISelection)new StructuredSelection(this.selectedObjects.toArray()), true);
    }

    protected class SelectObjectAction
    extends Action {
        protected Object objectToSelect;

        public SelectObjectAction(String text, ImageDescriptor imageDescriptor) {
            super(text, imageDescriptor);
            this.setEnabled(false);
        }

        public void setObjectToSelect(Object objectToSelect) {
            this.objectToSelect = objectToSelect;
            this.setEnabled(objectToSelect != null);
        }

        public void run() {
            SimpleMappedObjectViewer.this.setSelection((ISelection)new StructuredSelection(new Object[]{this.objectToSelect}), true);
        }
    }
}

