/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jmerge;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.emf.codegen.jmerge.JControlModel;
import org.eclipse.emf.codegen.jmerge.JPatternDictionary;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMField;
import org.eclipse.jdt.core.jdom.IDOMImport;
import org.eclipse.jdt.core.jdom.IDOMInitializer;
import org.eclipse.jdt.core.jdom.IDOMMember;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.core.jdom.IDOMPackage;
import org.eclipse.jdt.core.jdom.IDOMType;

public class JMerger
implements IPlatformRunnable {
    protected DOMFactory jdomFactory = new DOMFactory();
    protected JControlModel jControlModel;
    protected IDOMCompilationUnit sourceCompilationUnit;
    protected IDOMCompilationUnit targetCompilationUnit;
    protected JPatternDictionary sourcePatternDictionary;
    protected JPatternDictionary targetPatternDictionary;
    protected Map sourceToTargetMap = new HashMap();
    protected Map targetToSourceMap = new HashMap();
    protected Map orderedSourceChildrenMap = new HashMap();
    protected boolean isBlocked;
    protected static String lineSeparator;
    protected static Pattern braceLine;
    protected static Pattern leadingTabs;
    protected static Object[] noArguments;
    static /* synthetic */ Class class$0;

    static {
        StringBuffer result = new StringBuffer();
        String s = System.getProperty("line.separator");
        int i = 0;
        int len = s.length();
        while (i < len) {
            char c = s.charAt(i);
            if (c == '\r') {
                result.append("\\r");
            } else if (c == '\n') {
                result.append("\\n");
            } else {
                throw new RuntimeException("Unexpected line separator character");
            }
            ++i;
        }
        lineSeparator = result.toString();
        braceLine = Pattern.compile("(\\s*" + lineSeparator + "\\s*\\{\\s*)" + lineSeparator);
        leadingTabs = Pattern.compile("^((\\t)+).*$", 8);
        noArguments = new Object[0];
    }

    public JMerger() {
    }

    public JMerger(JControlModel jControlModel, IDOMCompilationUnit sourceCompilationUnit, IDOMCompilationUnit targetCompilationUnit) {
        this.jControlModel = jControlModel;
        this.setSourceCompilationUnit(sourceCompilationUnit);
        this.setTargetCompilationUnit(targetCompilationUnit);
    }

    public void merge() {
        this.pullTargetCompilationUnit();
        if (!this.isBlocked) {
            this.pushSourceCompilationUnit();
            this.sweepTargetCompilationUnit();
            this.sortTargetCompilationUnit();
        }
    }

    public void remerge() {
        this.sourceToTargetMap.clear();
        this.targetToSourceMap.clear();
        this.orderedSourceChildrenMap.clear();
        this.isBlocked = false;
        this.merge();
    }

    public JControlModel getControlModel() {
        return this.jControlModel;
    }

    public void setControlModel(JControlModel jControlModel) {
        this.jControlModel = jControlModel;
    }

    public String getSourceCompilationUnitContents() {
        return this.sourceCompilationUnit.getContents();
    }

    public IDOMCompilationUnit getSourceCompilationUnit() {
        return this.sourceCompilationUnit;
    }

    public void setSourceCompilationUnit(IDOMCompilationUnit sourceCompilationUnit) {
        this.sourceCompilationUnit = sourceCompilationUnit;
        this.sourcePatternDictionary = new JPatternDictionary(sourceCompilationUnit, this.jControlModel);
    }

    public String getTargetCompilationUnitContents() {
        return this.targetCompilationUnit.getContents();
    }

    public IDOMCompilationUnit getTargetCompilationUnit() {
        return this.targetCompilationUnit;
    }

    public void setTargetCompilationUnit(IDOMCompilationUnit targetCompilationUnit) {
        this.targetCompilationUnit = targetCompilationUnit;
        this.targetPatternDictionary = new JPatternDictionary(targetCompilationUnit, this.jControlModel);
    }

    public JPatternDictionary getSourcePatternDictionary() {
        return this.sourcePatternDictionary;
    }

    public void setSourcePatternDictionary(JPatternDictionary sourcePatternDictionary) {
        this.sourcePatternDictionary = sourcePatternDictionary;
    }

    public JPatternDictionary getTargetPatternDictionary() {
        return this.targetPatternDictionary;
    }

    public void setTargetPatternDictionary(JPatternDictionary targetPatternDictionary) {
        this.targetPatternDictionary = targetPatternDictionary;
    }

    public Map getSourceToTargetMap() {
        return this.sourceToTargetMap;
    }

    public void setSourceToTargetMap(Map sourceToTargetMap) {
        this.sourceToTargetMap = sourceToTargetMap;
    }

    public IDOMCompilationUnit createCompilationUnitForURI(String uri) {
        try {
            URL url = null;
            try {
                url = new URL(uri);
            }
            catch (MalformedURLException malformedURLException) {
                url = new URL("file:" + uri);
            }
            if (url != null) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(url.openStream());
                byte[] input = new byte[bufferedInputStream.available()];
                bufferedInputStream.read(input);
                bufferedInputStream.close();
                return this.jdomFactory.createCompilationUnit(new String(input), url.toString());
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    public IDOMCompilationUnit createCompilationUnitForInputStream(InputStream inputStream) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] input = new byte[bufferedInputStream.available()];
            bufferedInputStream.read(input);
            bufferedInputStream.close();
            return this.jdomFactory.createCompilationUnit(new String(input), "NAME");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public IDOMCompilationUnit createCompilationUnitForContents(String contents) {
        return this.jdomFactory.createCompilationUnit(contents, "NAME");
    }

    protected void pullTargetCompilationUnit() {
        if (this.targetCompilationUnit == null) {
            this.setTargetCompilationUnit((IDOMCompilationUnit)this.insertClone((IDOMNode)this.sourceCompilationUnit));
        } else {
            this.map((IDOMNode)this.sourceCompilationUnit, (IDOMNode)this.targetCompilationUnit);
            this.applyPullRules((IDOMNode)this.sourceCompilationUnit, (IDOMNode)this.targetCompilationUnit);
            IDOMNode child = this.targetCompilationUnit.getFirstChild();
            while (child != null) {
                switch (child.getNodeType()) {
                    case 2: {
                        this.pullTargetPackage((IDOMPackage)child);
                        break;
                    }
                    case 3: {
                        this.pullTargetImport((IDOMImport)child);
                        break;
                    }
                    case 4: {
                        IDOMType type = (IDOMType)child;
                        boolean bl = this.isBlocked = this.jControlModel.getBlockPattern() != null && type.getComment() != null && this.jControlModel.getBlockPattern().matcher(type.getComment()).find();
                        if (this.isBlocked) break;
                        this.pullTargetType(type);
                    }
                }
                child = child.getNextNode();
            }
        }
    }

    protected void pullTargetPackage(IDOMPackage targetPackage) {
        IDOMPackage sourcePackage = this.sourcePatternDictionary.getPackage();
        this.map((IDOMNode)sourcePackage, (IDOMNode)targetPackage);
        this.applyPullRules((IDOMNode)sourcePackage, (IDOMNode)targetPackage);
    }

    protected void pullTargetImport(IDOMImport targetImport) {
        IDOMImport sourceImport = (IDOMImport)this.sourcePatternDictionary.getImportMap().get(this.targetPatternDictionary.getQualifiedName((IDOMNode)targetImport));
        this.map((IDOMNode)sourceImport, (IDOMNode)targetImport);
        if (sourceImport != null) {
            this.applyPullRules((IDOMNode)sourceImport, (IDOMNode)targetImport);
        }
    }

    protected void pullTargetType(IDOMType targetType) {
        IDOMType sourceType = (IDOMType)this.sourcePatternDictionary.getTypeMap().get(this.targetPatternDictionary.getQualifiedName((IDOMNode)targetType));
        this.map((IDOMNode)sourceType, (IDOMNode)targetType);
        if (sourceType != null) {
            this.applyPullRules((IDOMNode)sourceType, (IDOMNode)targetType);
        }
        IDOMNode child = targetType.getFirstChild();
        while (child != null) {
            switch (child.getNodeType()) {
                case 7: {
                    this.pullTargetInitializer((IDOMInitializer)child);
                    break;
                }
                case 5: {
                    this.pullTargetField((IDOMField)child);
                    break;
                }
                case 6: {
                    this.pullTargetMethod((IDOMMethod)child);
                    break;
                }
                case 4: {
                    this.pullTargetType((IDOMType)child);
                }
            }
            child = child.getNextNode();
        }
    }

    protected void pullTargetInitializer(IDOMInitializer targetInitializer) {
        IDOMInitializer sourceInitializer = (IDOMInitializer)this.sourcePatternDictionary.getInitializerMap().get(this.targetPatternDictionary.getQualifiedName((IDOMNode)targetInitializer));
        this.map((IDOMNode)sourceInitializer, (IDOMNode)targetInitializer);
        if (sourceInitializer != null) {
            this.applyPullRules((IDOMNode)sourceInitializer, (IDOMNode)targetInitializer);
        }
    }

    protected void pullTargetField(IDOMField targetField) {
        IDOMField sourceField = (IDOMField)this.sourcePatternDictionary.getFieldMap().get(this.targetPatternDictionary.getQualifiedName((IDOMNode)targetField));
        this.map((IDOMNode)sourceField, (IDOMNode)targetField);
        if (sourceField != null) {
            this.applyPullRules((IDOMNode)sourceField, (IDOMNode)targetField);
        }
    }

    protected void pullTargetMethod(IDOMMethod targetMethod) {
        String qualifiedTargetMethodName = this.targetPatternDictionary.getQualifiedName((IDOMNode)targetMethod);
        IDOMMethod sourceMethod = (IDOMMethod)this.sourcePatternDictionary.getMethodMap().get(qualifiedTargetMethodName);
        if (sourceMethod == null && this.jControlModel.getRedirect() != null && targetMethod.getName() != null && targetMethod.getName().endsWith(this.jControlModel.getRedirect())) {
            int index = qualifiedTargetMethodName.indexOf("(");
            qualifiedTargetMethodName = String.valueOf(qualifiedTargetMethodName.substring(0, index - this.jControlModel.getRedirect().length())) + qualifiedTargetMethodName.substring(index);
            sourceMethod = (IDOMMethod)this.sourcePatternDictionary.getMethodMap().get(qualifiedTargetMethodName);
        }
        this.map((IDOMNode)sourceMethod, (IDOMNode)targetMethod);
        if (sourceMethod != null) {
            this.applyPullRules((IDOMNode)sourceMethod, (IDOMNode)targetMethod);
        }
    }

    protected String applyFormatRules(String value) {
        final String tabReplacement = this.jControlModel.getLeadingTabReplacement();
        if (tabReplacement != null) {
            FindAndReplace findAndReplaceLeadingTabs = new FindAndReplace(leadingTabs){

                public boolean handleMatch(int offset, Matcher matcher) {
                    if (matcher.groupCount() >= 1) {
                        int begin = offset + matcher.start(1);
                        int end = offset + matcher.end(1);
                        StringBuffer replacement = new StringBuffer();
                        int i = begin;
                        while (i < end) {
                            replacement.append(tabReplacement);
                            ++i;
                        }
                        this.replace(begin, end, replacement.toString());
                    }
                    return true;
                }
            };
            value = findAndReplaceLeadingTabs.apply(value);
        }
        if (this.jControlModel.convertToStandardBraceStyle()) {
            FindAndReplace findAndReplaceLineWithJustABrace = new FindAndReplace(braceLine){

                public boolean handleMatch(int offset, Matcher matcher) {
                    if (matcher.groupCount() >= 1) {
                        int begin = offset + matcher.start(1);
                        if (this.current != 0 && (begin <= this.current || this.string.charAt(begin - 1) == ';')) {
                            return true;
                        }
                        int i = begin - 1;
                        while (i >= this.current) {
                            char character = this.string.charAt(i);
                            if (character == '\n' || character == '\r') {
                                boolean slash = false;
                                while (++i < begin) {
                                    character = this.string.charAt(i);
                                    if (character == '/') {
                                        if (slash) {
                                            return true;
                                        }
                                        slash = true;
                                        continue;
                                    }
                                    slash = false;
                                }
                                break;
                            }
                            --i;
                        }
                        int end = offset + matcher.end(1);
                        this.replace(begin, end, " {");
                    }
                    return true;
                }
            };
            value = findAndReplaceLineWithJustABrace.apply(value);
        }
        return value;
    }

    protected void applyPullRules(IDOMNode sourceNode, IDOMNode targetNode) {
        try {
            Iterator pullRules = this.jControlModel.getPullRules().iterator();
            while (pullRules.hasNext()) {
                JControlModel.PullRule pullRule = (JControlModel.PullRule)pullRules.next();
                if (!this.sourcePatternDictionary.isMarkedUp(pullRule.getSourceMarkup(), sourceNode) || !this.targetPatternDictionary.isMarkedUp(pullRule.getTargetMarkup(), targetNode) || !pullRule.getSourceGetFeature().getFeatureClass().isInstance(sourceNode) || !pullRule.getTargetPutFeature().getFeatureClass().isInstance(targetNode)) continue;
                Method sourceGetMethod = pullRule.getSourceGetFeature().getFeatureMethod();
                Object value = sourceGetMethod.invoke((Object)sourceNode, noArguments);
                Method targetPutMethod = pullRule.getTargetPutFeature().getFeatureMethod();
                if (!sourceGetMethod.getReturnType().isArray() || targetPutMethod.getParameterTypes()[0].isAssignableFrom(sourceGetMethod.getReturnType())) {
                    if (value instanceof String) {
                        String stringValue = (String)value;
                        stringValue = this.applyFormatRules(stringValue);
                        Pattern sourceTransfer = pullRule.getSourceTransfer();
                        if (sourceTransfer != null) {
                            String oldStringValue = (String)sourceGetMethod.invoke((Object)targetNode, noArguments);
                            Matcher sourceMatcher = sourceTransfer.matcher(stringValue);
                            Matcher targetMatcher = sourceTransfer.matcher(oldStringValue);
                            stringValue = sourceMatcher.find() && targetMatcher.find() && sourceMatcher.groupCount() >= 1 && targetMatcher.groupCount() >= 1 ? String.valueOf(stringValue.substring(0, sourceMatcher.start(1))) + targetMatcher.group(1) + stringValue.substring(sourceMatcher.end(1)) : null;
                        }
                        value = stringValue;
                    }
                    if (value == null && !targetPutMethod.getName().equals("setInitializer") && !targetPutMethod.getName().equals("setSuperclass") && !targetPutMethod.getName().equals("setExceptions")) continue;
                    Object oldValue = sourceGetMethod.invoke((Object)targetNode, noArguments);
                    if (value != null ? value.equals(oldValue) : oldValue == null) continue;
                    if (targetPutMethod.getName().equals("setSuperclass") && oldValue != null && value != null && ((String)oldValue).trim().equals(((String)value).trim())) continue;
                    targetPutMethod.invoke((Object)targetNode, value);
                    if (!targetPutMethod.getName().equals("setBody") || !(sourceNode instanceof IDOMMethod)) continue;
                    IDOMMethod sourceMethod = (IDOMMethod)sourceNode;
                    IDOMMethod targetMethod = (IDOMMethod)targetNode;
                    String[] sourceParameterNames = sourceMethod.getParameterNames();
                    String[] targetParameterTypes = targetMethod.getParameterTypes();
                    targetMethod.setParameters(targetParameterTypes, sourceParameterNames);
                    continue;
                }
                ArrayList<String> additionalStrings = new ArrayList<String>();
                String[] sourceStrings = (String[])value;
                if (sourceStrings != null) {
                    additionalStrings.addAll(Arrays.asList(sourceStrings));
                }
                if (targetPutMethod.getName().equals("addSuperInterface")) {
                    Pattern sourceTransfer = pullRule.getSourceTransfer();
                    if (sourceTransfer != null) {
                        String comment = ((IDOMMember)targetNode).getComment();
                        Matcher matcher = sourceTransfer.matcher(comment);
                        while (matcher.find() && matcher.groupCount() >= 1) {
                            String clientStrings = comment.substring(matcher.start(matcher.groupCount()), matcher.end(matcher.groupCount()));
                            StringTokenizer stringTokenizer = new StringTokenizer(clientStrings, ", \t\n\r\f");
                            while (stringTokenizer.hasMoreTokens()) {
                                String token = stringTokenizer.nextToken();
                                if (additionalStrings.contains(token)) continue;
                                additionalStrings.add(token);
                            }
                        }
                    }
                    IDOMType type = (IDOMType)targetNode;
                    Object[] superInterfaces = additionalStrings.toArray(new String[additionalStrings.size()]);
                    if (!(type.getSuperInterfaces() == null ? superInterfaces.length != 0 : !Arrays.equals(type.getSuperInterfaces(), superInterfaces))) continue;
                    type.setSuperInterfaces(additionalStrings.toArray(new String[additionalStrings.size()]));
                    continue;
                }
                String[] oldStringValues = (String[])sourceGetMethod.invoke((Object)targetNode, noArguments);
                List<String> old = oldStringValues == null ? Collections.EMPTY_LIST : Arrays.asList(oldStringValues);
                Iterator i = additionalStrings.iterator();
                while (i.hasNext()) {
                    String string = (String)i.next();
                    if (old.contains(string)) continue;
                    targetPutMethod.invoke((Object)targetNode, string);
                }
            }
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
    }

    protected void pushSourceCompilationUnit() {
        IDOMNode child = this.sourceCompilationUnit.getFirstChild();
        while (child != null) {
            switch (child.getNodeType()) {
                case 2: {
                    this.pushSourcePackage((IDOMPackage)child);
                    break;
                }
                case 3: {
                    this.pushSourceImport((IDOMImport)child);
                    break;
                }
                case 4: {
                    this.pushSourceType((IDOMType)child);
                }
            }
            child = child.getNextNode();
        }
    }

    protected void pushSourcePackage(IDOMPackage sourcePackage) {
        if (!this.sourceToTargetMap.containsKey(sourcePackage)) {
            this.insertClone((IDOMNode)sourcePackage);
        }
    }

    protected void pushSourceImport(IDOMImport sourceImport) {
        if (!this.sourceToTargetMap.containsKey(sourceImport) && !this.targetPatternDictionary.isNoImport(sourceImport)) {
            this.insertClone((IDOMNode)sourceImport);
        }
    }

    protected void pushSourceType(IDOMType sourceType) {
        if (!this.sourceToTargetMap.containsKey(sourceType)) {
            this.insertClone((IDOMNode)sourceType);
        } else {
            IDOMNode child = sourceType.getFirstChild();
            while (child != null) {
                switch (child.getNodeType()) {
                    case 7: {
                        this.pushSourceInitializer((IDOMInitializer)child);
                        break;
                    }
                    case 5: {
                        this.pushSourceField((IDOMField)child);
                        break;
                    }
                    case 6: {
                        this.pushSourceMethod((IDOMMethod)child);
                        break;
                    }
                    case 4: {
                        this.pushSourceType((IDOMType)child);
                    }
                }
                child = child.getNextNode();
            }
        }
    }

    protected void pushSourceInitializer(IDOMInitializer sourceInitializer) {
        if (!this.sourceToTargetMap.containsKey(sourceInitializer)) {
            this.insertClone((IDOMNode)sourceInitializer);
        }
    }

    protected void pushSourceField(IDOMField sourceField) {
        this.applySortRules((IDOMNode)sourceField);
        if (!this.sourceToTargetMap.containsKey(sourceField)) {
            this.insertClone((IDOMNode)sourceField);
        }
    }

    protected void pushSourceMethod(IDOMMethod sourceMethod) {
        if (!this.sourceToTargetMap.containsKey(sourceMethod)) {
            this.insertClone((IDOMNode)sourceMethod);
        }
    }

    public void applySortRules(IDOMNode sourceNode) {
        Iterator sortRules = this.jControlModel.getSortRules().iterator();
        while (sortRules.hasNext()) {
            JControlModel.SortRule sortRule = (JControlModel.SortRule)sortRules.next();
            if (!this.sourcePatternDictionary.isMarkedUp(sortRule.getMarkup(), sourceNode) || !sortRule.getSelector().isInstance(sourceNode)) continue;
            IDOMNode parent = sourceNode.getParent();
            ArrayList<IDOMNode> children = (ArrayList<IDOMNode>)this.orderedSourceChildrenMap.get(parent);
            if (children == null) {
                children = new ArrayList<IDOMNode>();
                this.orderedSourceChildrenMap.put(parent, children);
            }
            children.add(sourceNode);
            break;
        }
    }

    protected void sweepTargetCompilationUnit() {
        Iterator entries = this.targetToSourceMap.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            if (entry.getValue() != null) continue;
            this.applySweepRules((IDOMNode)entry.getKey());
        }
    }

    protected void applySweepRules(IDOMNode targetNode) {
        Iterator sweepRules = this.jControlModel.getSweepRules().iterator();
        while (sweepRules.hasNext()) {
            JControlModel.SweepRule sweepRule = (JControlModel.SweepRule)sweepRules.next();
            Class clazz = sweepRule.getSelector();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.jdt.core.jdom.IDOMImport");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz2 && targetNode instanceof IDOMImport) {
                if (!sweepRule.getMarkup().matcher(targetNode.getName()).find()) continue;
                targetNode.remove();
                break;
            }
            if (!this.targetPatternDictionary.isMarkedUp(sweepRule.getMarkup(), targetNode) || !sweepRule.getSelector().isInstance(targetNode)) continue;
            targetNode.remove();
            break;
        }
    }

    protected void sortTargetCompilationUnit() {
        Iterator values = this.orderedSourceChildrenMap.values().iterator();
        while (values.hasNext()) {
            List children = (List)values.next();
            if (children.size() <= 2) continue;
            Iterator i = children.iterator();
            IDOMNode sourceNode = (IDOMNode)i.next();
            IDOMNode previousTargetNode = (IDOMNode)this.sourceToTargetMap.get(sourceNode);
            do {
                sourceNode = (IDOMNode)i.next();
                IDOMNode nextTargetNode = (IDOMNode)this.sourceToTargetMap.get(sourceNode);
                boolean reorder = true;
                IDOMNode domNode = nextTargetNode.getPreviousNode();
                while (domNode != null) {
                    if (domNode == previousTargetNode) {
                        reorder = false;
                        break;
                    }
                    domNode = domNode.getPreviousNode();
                }
                if (reorder) {
                    nextTargetNode.remove();
                    if (previousTargetNode.getNextNode() == null) {
                        previousTargetNode.getParent().addChild(nextTargetNode);
                    } else {
                        previousTargetNode.getNextNode().insertSibling(nextTargetNode);
                    }
                }
                previousTargetNode = nextTargetNode;
            } while (i.hasNext());
        }
    }

    protected IDOMNode insertClone(IDOMNode sourceNode) {
        IDOMNode targetSibling;
        IDOMNode targetNode = null;
        switch (sourceNode.getNodeType()) {
            case 1: {
                targetNode = this.jdomFactory.createCompilationUnit(this.applyFormatRules(sourceNode.getContents()), ((IDOMCompilationUnit)sourceNode).getName());
                break;
            }
            case 2: {
                targetNode = this.jdomFactory.createPackage(this.applyFormatRules(sourceNode.getContents()));
                break;
            }
            case 3: {
                targetNode = this.jdomFactory.createImport(this.applyFormatRules(sourceNode.getContents()));
                break;
            }
            case 4: {
                targetNode = this.jdomFactory.createType(this.applyFormatRules(sourceNode.getContents()));
                break;
            }
            case 7: {
                targetNode = this.jdomFactory.createInitializer(this.applyFormatRules(sourceNode.getContents()));
                break;
            }
            case 5: {
                targetNode = this.jdomFactory.createField(this.applyFormatRules(sourceNode.getContents()));
                break;
            }
            case 6: {
                targetNode = this.jdomFactory.createMethod(this.applyFormatRules(sourceNode.getContents()));
                break;
            }
            default: {
                targetNode = (IDOMNode)sourceNode.clone();
            }
        }
        if (targetNode != null) {
            this.map(sourceNode, targetNode);
            this.mapChildren(sourceNode, targetNode);
        }
        IDOMNode previousNode = sourceNode.getPreviousNode();
        while (previousNode != null) {
            targetSibling = (IDOMNode)this.sourceToTargetMap.get(previousNode);
            if (targetSibling != null) {
                IDOMNode targetNextSibling = targetSibling.getNextNode();
                if (targetNextSibling == null) {
                    targetSibling.getParent().addChild(targetNode);
                } else {
                    targetNextSibling.insertSibling(targetNode);
                }
                return targetNode;
            }
            previousNode = previousNode.getPreviousNode();
        }
        if (sourceNode.getParent() != null) {
            IDOMNode targetParent = (IDOMNode)this.sourceToTargetMap.get(sourceNode.getParent());
            targetSibling = targetParent.getFirstChild();
            if (targetSibling == null) {
                targetParent.addChild(targetNode);
            } else {
                targetSibling.insertSibling(targetNode);
            }
        }
        return targetNode;
    }

    protected void mapChildren(IDOMNode sourceNode, IDOMNode targetNode) {
        this.map(sourceNode, targetNode);
        IDOMNode sourceChild = sourceNode.getFirstChild();
        IDOMNode targetChild = targetNode.getFirstChild();
        while (sourceChild != null) {
            this.mapChildren(sourceChild, targetChild);
            sourceChild = sourceChild.getNextNode();
            targetChild = targetChild.getNextNode();
        }
    }

    protected void map(IDOMNode sourceNode, IDOMNode targetNode) {
        if (sourceNode != null) {
            this.sourceToTargetMap.put(sourceNode, targetNode);
        }
        this.targetToSourceMap.put(targetNode, sourceNode);
    }

    public Object run(Object object) {
        try {
            String[] arguments = (String[])object;
            this.jControlModel = new JControlModel(arguments[0]);
            this.sourceCompilationUnit = this.createCompilationUnitForURI(arguments[1]);
            this.targetCompilationUnit = this.createCompilationUnitForURI(arguments[2]);
            this.sourcePatternDictionary = new JPatternDictionary(this.sourceCompilationUnit, this.jControlModel);
            this.targetPatternDictionary = new JPatternDictionary(this.targetCompilationUnit, this.jControlModel);
            this.pullTargetCompilationUnit();
            if (!this.isBlocked) {
                this.pushSourceCompilationUnit();
                this.sweepTargetCompilationUnit();
                this.sortTargetCompilationUnit();
            }
            System.out.println("**********************************************");
            System.out.println(this.targetCompilationUnit.getContents());
            return new Integer(0);
        }
        catch (Exception exception) {
            return new Integer(1);
        }
    }

    public static abstract class FindAndReplace {
        protected Pattern pattern;
        protected String string;
        protected StringBuffer stringBuffer;
        protected int current;

        public FindAndReplace(Pattern pattern) {
            this.pattern = pattern;
        }

        public String apply(String string) {
            this.current = 0;
            this.string = string;
            this.stringBuffer = new StringBuffer();
            string.length();
            new ArrayList();
            int start = 0;
            int end = string.length();
            while (start < end) {
                Matcher matcher = this.pattern.matcher(string.subSequence(start, end));
                if (!matcher.find() || !this.handleMatch(start, matcher)) break;
                start += matcher.end();
            }
            this.stringBuffer.append(string.substring(this.current));
            return this.stringBuffer.toString();
        }

        public void replace(int begin, int end, String replacement) {
            this.stringBuffer.append(this.string.substring(this.current, begin));
            this.stringBuffer.append(replacement);
            this.current = end;
        }

        public abstract boolean handleMatch(int var1, Matcher var2);
    }
}

