/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.codegen.CodeGenPlugin;
import org.eclipse.emf.codegen.jet.JETCharDataGenerator;
import org.eclipse.emf.codegen.jet.JETConstantDataGenerator;
import org.eclipse.emf.codegen.jet.JETCoreElement;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.jet.JETExpressionGenerator;
import org.eclipse.emf.codegen.jet.JETGenerator;
import org.eclipse.emf.codegen.jet.JETMark;
import org.eclipse.emf.codegen.jet.JETParseEventListener;
import org.eclipse.emf.codegen.jet.JETParser;
import org.eclipse.emf.codegen.jet.JETReader;
import org.eclipse.emf.codegen.jet.JETScriptletGenerator;
import org.eclipse.emf.codegen.jet.JETSkeleton;

public class JETCompiler
implements JETParseEventListener {
    protected static final char[] NULL_CHAR_ARRAY = new char[0];
    protected String[] templateURIPath;
    protected String templateURI;
    protected JETParser parser;
    protected JETSkeleton skeleton;
    protected JETReader reader;
    protected PrintWriter writer;
    protected List generators = new ArrayList(100);
    protected List constants = new ArrayList(100);
    protected Map constantDictionary = new HashMap(100, 100.0f);
    protected long constantCount = 0L;
    protected boolean fNoNewLineForScriptlets = true;
    protected boolean fUseStaticFinalConstants = true;
    protected char[] fSavedLine = null;
    protected static final String CONSTANT_PREFIX = "TEXT_";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public JETCompiler(String templateURI) throws JETException {
        this(templateURI, "UTF8");
    }

    public JETCompiler(String templateURI, String encoding) throws JETException {
        this(templateURI, JETCompiler.openStream(templateURI), encoding);
    }

    public JETCompiler(String templateURI, InputStream inputStream, String encoding) throws JETException {
        this.templateURI = templateURI;
        this.reader = new JETReader(templateURI, inputStream, encoding);
    }

    public JETCompiler(String[] templateURIPath, String relativeTemplateURI) throws JETException {
        this(templateURIPath, relativeTemplateURI, "UTF8");
    }

    public JETCompiler(String[] templateURIPath, String relativeTemplateURI, String encoding) throws JETException {
        this.templateURIPath = templateURIPath;
        this.templateURI = relativeTemplateURI;
        String actualTemplateURI = JETCompiler.find(templateURIPath, relativeTemplateURI);
        this.reader = new JETReader(relativeTemplateURI, JETCompiler.openStream(actualTemplateURI), encoding);
    }

    public String getResolvedTemplateURI() {
        return this.reader.getFile(0);
    }

    public void handleDirective(String directive, JETMark start, JETMark stop, Map attributes) throws JETException {
        this.fSavedLine = null;
        if (directive.equals("include")) {
            String fileURI = (String)attributes.get("file");
            if (fileURI != null) {
                String currentURI = start.getFile();
                String[] resolvedFileURI = JETCompiler.resolveLocation(this.templateURIPath, currentURI, fileURI);
                try {
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(JETCompiler.openStream(resolvedFileURI[1]));
                    this.reader.stackStream(resolvedFileURI[0], bufferedInputStream, null);
                }
                catch (JETException exception) {
                    throw new JETException(CodeGenPlugin.getPlugin().getString("jet.error.file.cannot.read", new Object[]{resolvedFileURI[1], start.format("jet.mark.file.line.column")}), (Throwable)((Object)exception));
                }
            }
            throw new JETException(CodeGenPlugin.getPlugin().getString("jet.error.missing.attribute", new Object[]{"href", start.format("jet.mark.file.line.column")}));
        }
        if (directive.equals("jet") && this.skeleton == null) {
            this.skeleton = new JETSkeleton();
            String skeletonURI = (String)attributes.get("skeleton");
            if (skeletonURI != null) {
                try {
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(JETCompiler.openStream(JETCompiler.resolveLocation(this.templateURIPath, this.templateURI, skeletonURI)[1]));
                    byte[] input = new byte[bufferedInputStream.available()];
                    bufferedInputStream.read(input);
                    bufferedInputStream.close();
                    this.skeleton.setCompilationUnitContents(new String(input));
                }
                catch (IOException exception) {
                    throw new JETException(exception);
                }
            }
            Iterator entries = attributes.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                if (entry.getKey().equals("skeleton")) continue;
                if (entry.getKey().equals("package")) {
                    this.skeleton.setPackageName((String)entry.getValue());
                    continue;
                }
                if (entry.getKey().equals("imports")) {
                    this.skeleton.addImports((String)entry.getValue());
                    continue;
                }
                if (entry.getKey().equals("class")) {
                    this.skeleton.setClassName((String)entry.getValue());
                    continue;
                }
                if (entry.getKey().equals("nlString")) {
                    this.skeleton.setNLString((String)entry.getValue());
                    continue;
                }
                if (entry.getKey().equals("startTag")) {
                    this.parser.setStartTag((String)entry.getValue());
                    continue;
                }
                if (entry.getKey().equals("endTag")) {
                    this.parser.setEndTag((String)entry.getValue());
                    continue;
                }
                if (entry.getKey().equals("version")) continue;
                throw new JETException(CodeGenPlugin.getPlugin().getString("jet.error.bad.attribute", new Object[]{entry.getKey(), start.format("jet.mark.file.line.column")}));
            }
            this.handleNewSkeleton();
        }
    }

    protected void handleNewSkeleton() {
    }

    public void handleExpression(JETMark start, JETMark stop, Map attributes) throws JETException {
        JETExpressionGenerator gen = new JETExpressionGenerator(this.reader.getChars(start, stop));
        this.addGenerator(gen);
    }

    public void handleScriptlet(JETMark start, JETMark stop, Map attributes) throws JETException {
        this.fSavedLine = null;
        JETScriptletGenerator gen = new JETScriptletGenerator(this.reader.getChars(start, stop));
        this.addGenerator(gen);
    }

    public void handleCharData(char[] chars) throws JETException {
        if (this.fNoNewLineForScriptlets) {
            char[] strippedChars = this.stripLastNewLineWithBlanks(chars);
            if (strippedChars.length > 0) {
                this.addCharDataGenerator(strippedChars);
            }
        } else {
            this.addCharDataGenerator(chars);
        }
    }

    public void addGenerator(JETGenerator gen) throws JETException {
        if (this.fSavedLine != null) {
            this.addCharDataGenerator(this.fSavedLine);
            this.fSavedLine = null;
        }
        this.generators.add(gen);
    }

    public void addCharDataGenerator(char[] chars) throws JETException {
        block11: {
            if (chars.length <= 500) break block11;
            int nl = 0;
            int lf = 0;
            int start = 0;
            int i = 0;
            while (i < chars.length) {
                block12: {
                    switch (chars[i]) {
                        case '\n': {
                            ++nl;
                            break;
                        }
                        case '\r': {
                            ++lf;
                            break;
                        }
                        default: {
                            break block12;
                        }
                    }
                    if (lf > 400 || nl > 400) {
                        ++i;
                        block8: while (i < chars.length) {
                            switch (chars[i]) {
                                case '\n': 
                                case '\r': {
                                    break;
                                }
                                default: {
                                    int size = i - start;
                                    char[] block = new char[size];
                                    System.arraycopy(chars, start, block, 0, size);
                                    this.doAddCharDataGenerator(block);
                                    start = i;
                                    nl = 0;
                                    lf = 0;
                                    break block8;
                                }
                            }
                            ++i;
                        }
                    }
                }
                ++i;
            }
            if (start != 0) {
                int size = chars.length - start;
                char[] block = new char[size];
                System.arraycopy(chars, start, block, 0, size);
                this.doAddCharDataGenerator(block);
                return;
            }
        }
        this.doAddCharDataGenerator(chars);
    }

    public void doAddCharDataGenerator(char[] chars) throws JETException {
        if (this.fUseStaticFinalConstants) {
            JETConstantDataGenerator gen = (JETConstantDataGenerator)this.constantDictionary.get(chars);
            if (gen == null) {
                if (this.constantCount == 0L) {
                    chars = this.stripFirstNewLineWithBlanks(chars);
                }
                ++this.constantCount;
                String label = CONSTANT_PREFIX + this.constantCount;
                gen = new JETConstantDataGenerator(chars, label);
                this.constantDictionary.put(chars, gen);
                this.constants.add(gen);
            }
            this.generators.add(gen);
        } else {
            this.generators.add(new JETCharDataGenerator(chars));
        }
    }

    protected char[] stripFirstNewLineWithBlanks(char[] chars) {
        if (chars.length >= 2 && (chars[0] == '\n' && chars[1] == '\r' || chars[0] == '\r' && chars[1] == '\n')) {
            chars = new String(chars, 2, chars.length - 2).toCharArray();
        } else if (chars.length >= 1 && (chars[0] == '\n' || chars[0] == '\r')) {
            chars = new String(chars, 1, chars.length - 1).toCharArray();
        }
        return chars;
    }

    protected char[] stripLastNewLineWithBlanks(char[] chars) {
        int i = chars.length - 1;
        while (i > 0 && chars[i] == ' ') {
            --i;
        }
        if (chars[i] == '\n') {
            if (i > 0 && chars[i - 1] == '\r') {
                --i;
            }
            this.fSavedLine = new String(chars, i, chars.length - i).toCharArray();
            if (i == 0) {
                return NULL_CHAR_ARRAY;
            }
            chars = new String(chars, 0, i).toCharArray();
            return chars;
        }
        return chars;
    }

    public void beginPageProcessing() {
    }

    public void endPageProcessing() throws JETException {
        if (this.skeleton == null) {
            throw new JETException(CodeGenPlugin.getPlugin().getString("jet.error.missing.jet.directive", new Object[]{this.reader.mark().format("jet.mark.file.line.column")}));
        }
        if (this.fSavedLine != null) {
            this.addCharDataGenerator(this.fSavedLine);
        }
        ArrayList<String> generatedConstants = new ArrayList<String>(this.constants.size());
        Iterator i = this.constants.iterator();
        while (i.hasNext()) {
            generatedConstants.add(((JETConstantDataGenerator)i.next()).generateConstant());
        }
        this.skeleton.setConstants(generatedConstants);
        ArrayList<String> generatedBody = new ArrayList<String>(this.generators.size());
        Iterator i2 = this.generators.iterator();
        while (i2.hasNext()) {
            generatedBody.add(((JETGenerator)i2.next()).generate());
        }
        this.skeleton.setBody(generatedBody);
        this.writer.print(this.skeleton.getCompilationUnitContents());
    }

    public void parse() throws JETException {
        JETParser.Directive directive = new JETParser.Directive();
        directive.getDirectives().add("jet");
        directive.getDirectives().add("include");
        JETCoreElement[] coreElements = new JETCoreElement[]{directive, new JETParser.QuoteEscape(), new JETParser.Expression(), new JETParser.Scriptlet()};
        Class[] classArray = new Class[4];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.codegen.jet.JETParser$Directive");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.emf.codegen.jet.JETParser$QuoteEscape");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.emf.codegen.jet.JETParser$Expression");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.emf.codegen.jet.JETParser$Scriptlet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[3] = clazz4;
        Class[] accept = classArray;
        this.parse(coreElements, accept);
    }

    protected void parse(JETCoreElement[] coreElements, Class[] accept) throws JETException {
        this.parser = new JETParser(this.reader, this, coreElements);
        this.beginPageProcessing();
        this.parser.parse(null, accept);
    }

    public void generate(OutputStream oStream) throws JETException {
        this.writer = new PrintWriter(oStream);
        this.endPageProcessing();
        this.writer.close();
    }

    public JETSkeleton getSkeleton() {
        return this.skeleton;
    }

    protected static String[] resolveLocation(String[] templateURIPath, String baseLocationURI, String locationURI) {
        String[] result = new String[]{locationURI, locationURI};
        try {
            String file;
            try {
                URL url = new URL(locationURI);
                url = Platform.resolve((URL)url);
                file = url.getFile();
            }
            catch (MalformedURLException malformedURLException) {
                file = locationURI;
            }
            Path path = new Path(file);
            if (!path.isAbsolute()) {
                String resolvedLocation = "";
                int index = baseLocationURI.lastIndexOf("/");
                if (index != -1) {
                    resolvedLocation = baseLocationURI.substring(0, index + 1);
                }
                result[0] = resolvedLocation = String.valueOf(resolvedLocation) + path;
                if (templateURIPath != null) {
                    resolvedLocation = JETCompiler.find(templateURIPath, resolvedLocation);
                }
                if (resolvedLocation != null) {
                    result[1] = resolvedLocation;
                }
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    public static String find(String[] locationURIPath, String relativeLocationURI) {
        String result = null;
        int i = 0;
        while (i < locationURIPath.length) {
            try {
                result = locationURIPath[i];
                if (!result.endsWith("/")) {
                    result = String.valueOf(result) + "/";
                }
                result = String.valueOf(result) + relativeLocationURI;
                InputStream inputStream = JETCompiler.openStream(result);
                inputStream.close();
                break;
            }
            catch (JETException jETException) {
                result = null;
            }
            catch (IOException iOException) {
                result = null;
            }
            ++i;
        }
        return result;
    }

    public static InputStream openStream(String locationURI) throws JETException {
        try {
            URL url = null;
            try {
                url = new URL(locationURI);
                url = Platform.resolve((URL)url);
            }
            catch (MalformedURLException malformedURLException) {
                url = new URL("file:" + locationURI);
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(url.openStream());
            return bufferedInputStream;
        }
        catch (IOException exception) {
            throw new JETException(exception.getLocalizedMessage(), exception);
        }
    }
}

