/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.genmodel.presentation;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.genmodel.presentation.EMFProjectWizard;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenModelEditPlugin;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class GenModelModelWizard
extends EMFProjectWizard {
    protected GenModelModelWizardNewFileCreationPage newFileCreationPage;

    public GenModelModelWizard() {
        this.whichStyle = 1;
        this.setWindowTitle(GenModelEditPlugin.INSTANCE.getString("_UI_New_title"));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(GenModelEditPlugin.INSTANCE.getImage("full/wizban/NewGenModel")));
    }

    public void addPages() {
        Object selectedElement;
        this.newFileCreationPage = new GenModelModelWizardNewFileCreationPage("Whatever", this.selection);
        this.newFileCreationPage.setTitle(GenModelEditPlugin.INSTANCE.getString("_UI_EMFModels_title"));
        this.newFileCreationPage.setDescription(GenModelEditPlugin.INSTANCE.getString("_UI_EMFModels_description"));
        this.newFileCreationPage.setFileName("My.genmodel");
        this.addPage((IWizardPage)this.newFileCreationPage);
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                selectedResource.getLocation().toOSString();
                this.newFileCreationPage.setContainerFullPath(selectedResource.getFullPath());
                String defaultModelBaseFilename = "My";
                String defaultModelFilenameExtension = "genmodel";
                String modelFilename = String.valueOf(defaultModelBaseFilename) + "." + defaultModelFilenameExtension;
                int i = 1;
                while (((IContainer)selectedResource).findMember(modelFilename) != null) {
                    modelFilename = String.valueOf(defaultModelBaseFilename) + i + "." + defaultModelFilenameExtension;
                    ++i;
                }
                this.newFileCreationPage.setFileName(modelFilename);
            }
        }
        super.addPages();
    }

    public IFile getGenModelFile() {
        return this.newFileCreationPage.getGenModelFile();
    }

    public class GenModelModelWizardNewFileCreationPage
    extends WizardNewFileCreationPage {
        protected IFile modelFile;

        public GenModelModelWizardNewFileCreationPage(String pageId, IStructuredSelection selection) {
            super(pageId, selection);
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                String extension = new Path(this.getFileName()).getFileExtension();
                if (extension == null || !extension.equals("genmodel")) {
                    this.setErrorMessage(GenModelEditPlugin.INSTANCE.getString("_UI_GeneratorModelFileNameMustEndWithGenModel_message"));
                    return false;
                }
                return true;
            }
            return false;
        }

        public boolean performFinish() {
            this.modelFile = this.getGenModelFile();
            return true;
        }

        public IFile getGenModelFile() {
            return this.modelFile == null ? ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName())) : this.modelFile;
        }
    }
}

