/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.CodeGen;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class Generator
extends CodeGen {
    protected String basePackage;
    public static int EMF_MODEL_PROJECT_STYLE = 1;
    public static int EMF_EDIT_PROJECT_STYLE = 2;
    public static int EMF_EDITOR_PROJECT_STYLE = 4;
    public static int EMF_XML_PROJECT_STYLE = 8;
    public static int EMF_PLUGIN_PROJECT_STYLE = 16;
    public static int EMF_EMPTY_PROJECT_STYLE = 32;

    public static void main(String[] args) {
        new Generator().run(args);
    }

    public void printGenerateUsage() {
        System.out.println("Usage arguments:");
        System.out.println("  [-platform | -data] <workspace-directory> ");
        System.out.println("  [-projects ] <project-root-directory> ");
        System.out.println("  [-dynamicTemplates] [-forceOverwrite | -diff]");
        System.out.println("  [-generateSchema] [-nonNLSMarkers]");
        System.out.println("  [-model] [-edit] [-editor]");
        System.out.println("  <genmodel-file>");
        System.out.println("  [ <target-root-directory> ]");
        System.out.println("");
        System.out.println("For example:");
        System.out.println("");
        System.out.println("  generate result/src/model/Extended.genmodel");
    }

    public Object run(Object object) {
        try {
            final String[] arguments = (String[])object;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor progressMonitor) throws CoreException {
                    try {
                        block36: {
                            try {
                                GenModel genModel;
                                if (arguments.length == 0) {
                                    Generator.this.printGenerateUsage();
                                    break block36;
                                }
                                if ("-ecore2GenModel".equalsIgnoreCase(arguments[0])) {
                                    Path ecorePath = new Path(arguments[1]);
                                    Generator.this.basePackage = arguments[2];
                                    String prefix = arguments[3];
                                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                                    URI ecoreURI = URI.createFileURI((String)ecorePath.toString());
                                    Resource resource = resourceSet.getResource(ecoreURI, true);
                                    EPackage ePackage = (EPackage)resource.getContents().get(0);
                                    IPath genModelPath = ecorePath.removeFileExtension().addFileExtension("genmodel");
                                    progressMonitor.beginTask("", 2);
                                    progressMonitor.subTask("Creating " + genModelPath);
                                    URI genModelURI = URI.createFileURI((String)genModelPath.toString());
                                    Resource genModelResource = Resource.Factory.Registry.INSTANCE.getFactory(genModelURI).createResource(genModelURI);
                                    GenModel genModel2 = GenModelFactory.eINSTANCE.createGenModel();
                                    genModelResource.getContents().add((Object)genModel2);
                                    resourceSet.getResources().add((Object)genModelResource);
                                    genModel2.setModelDirectory("/TargetProject/src");
                                    genModel2.getForeignModel().add((Object)ecorePath.toString());
                                    genModel2.initialize(Collections.singleton(ePackage));
                                    GenPackage genPackage = (GenPackage)genModel2.getGenPackages().get(0);
                                    genModel2.setModelName(genModelURI.trimFileExtension().lastSegment());
                                    genPackage.setPrefix(prefix);
                                    genPackage.setBasePackage(Generator.this.basePackage);
                                    progressMonitor.worked(1);
                                    if (arguments.length > 4 && "-sdo".equals(arguments[4])) {
                                        Generator.setSDODefaults(genModel2);
                                    }
                                    genModelResource.save(Collections.EMPTY_MAP);
                                    break block36;
                                }
                                String rootLocation = null;
                                boolean dynamicTemplates = false;
                                boolean diff = false;
                                boolean forceOverwrite = false;
                                boolean generateSchema = false;
                                boolean nonNLSMarkers = false;
                                boolean model = false;
                                boolean edit = false;
                                boolean editor = false;
                                int index = 0;
                                while (true) {
                                    if (index >= arguments.length || !arguments[index].startsWith("-")) {
                                        if (!(model || edit || editor)) {
                                            model = true;
                                        }
                                        String genModelName = arguments[index++];
                                        progressMonitor.beginTask("Generating " + genModelName, 2);
                                        ResourceSetImpl resourceSet = new ResourceSetImpl();
                                        URI genModelURI = URI.createFileURI((String)new File(genModelName).getAbsoluteFile().getCanonicalPath());
                                        Resource genModelResource = resourceSet.getResource(genModelURI, true);
                                        genModel = (GenModel)genModelResource.getContents().get(0);
                                        IStatus status = genModel.validate();
                                        if (status.isOK()) break;
                                        Generator.this.printStatus("", status);
                                        break block36;
                                    }
                                    if (arguments[index].equalsIgnoreCase("-projects")) {
                                        rootLocation = new File(arguments[++index]).getAbsoluteFile().getCanonicalPath();
                                    } else if (arguments[index].equalsIgnoreCase("-dynamicTemplates")) {
                                        dynamicTemplates = true;
                                    } else if (arguments[index].equalsIgnoreCase("-diff")) {
                                        diff = true;
                                    } else if (arguments[index].equalsIgnoreCase("-forceOverwrite")) {
                                        forceOverwrite = true;
                                    } else if (arguments[index].equalsIgnoreCase("-generateSchema")) {
                                        generateSchema = true;
                                    } else if (arguments[index].equalsIgnoreCase("-nonNLSMarkers")) {
                                        nonNLSMarkers = true;
                                    } else if (arguments[index].equalsIgnoreCase("-model")) {
                                        model = true;
                                    } else if (arguments[index].equalsIgnoreCase("-edit")) {
                                        edit = true;
                                    } else {
                                        if (!arguments[index].equalsIgnoreCase("-editor")) throw new CoreException((IStatus)new Status(4, CodeGenEcorePlugin.getPlugin().getBundle().getSymbolicName(), 0, "Unrecognized argument: '" + arguments[index] + "'", null));
                                        editor = true;
                                    }
                                    ++index;
                                }
                                if (dynamicTemplates) {
                                    genModel.setDynamicTemplates(dynamicTemplates);
                                }
                                genModel.setForceOverwrite(forceOverwrite);
                                genModel.setRedirection(diff ? ".{0}.new" : "");
                                if (index < arguments.length) {
                                    Path path = new Path(genModel.getModelDirectory());
                                    Path targetRootDirectory = new Path(arguments[index]);
                                    targetRootDirectory = new Path(targetRootDirectory.toFile().getAbsoluteFile().getCanonicalPath());
                                    CodeGen.findOrCreateContainer((IPath)new Path(path.segment(0)), (boolean)true, (IPath)targetRootDirectory, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                                } else {
                                    String editorDirectory;
                                    String modelDirectory = genModel.getModelDirectory();
                                    genModel.setModelDirectory(Generator.this.findOrCreateContainerHelper(rootLocation, modelDirectory, progressMonitor));
                                    String editDirectory = genModel.getEditDirectory();
                                    if (editDirectory != null) {
                                        genModel.setEditDirectory(Generator.this.findOrCreateContainerHelper(rootLocation, editDirectory, progressMonitor));
                                    }
                                    if ((editorDirectory = genModel.getEditorDirectory()) != null) {
                                        genModel.setEditorDirectory(Generator.this.findOrCreateContainerHelper(rootLocation, editorDirectory, progressMonitor));
                                    }
                                }
                                genModel.setCanGenerate(true);
                                genModel.setUpdateClasspath(false);
                                genModel.setGenerateSchema(generateSchema);
                                genModel.setNonNLSMarkers(nonNLSMarkers);
                                if (model) {
                                    genModel.generate((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                                }
                                if (edit) {
                                    genModel.generateEdit((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                                }
                                if (editor) {
                                    genModel.generateEditor((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                                }
                            }
                            catch (CoreException exception) {
                                throw exception;
                            }
                            catch (Exception exception) {
                                throw new CoreException((IStatus)new Status(4, CodeGenEcorePlugin.getPlugin().getBundle().getSymbolicName(), 0, "EMF Error", (Throwable)exception));
                            }
                        }
                        Object var21_38 = null;
                    }
                    catch (Throwable throwable) {
                        Object var21_37 = null;
                        progressMonitor.done();
                        throw throwable;
                    }
                    progressMonitor.done();
                }
            };
            workspace.run(runnable, (IProgressMonitor)new CodeGen.StreamProgressMonitor(System.out));
            return new Integer(0);
        }
        catch (Exception exception) {
            this.printGenerateUsage();
            exception.printStackTrace();
            CodeGenEcorePlugin.INSTANCE.log(exception);
            return new Integer(1);
        }
    }

    protected String findOrCreateContainerHelper(String rootLocation, String encodedPath, IProgressMonitor progressMonitor) throws CoreException {
        int index = encodedPath.indexOf("/./");
        if (encodedPath.endsWith("/.") && index != -1) {
            Path modelProjectLocation = new Path(encodedPath.substring(0, index));
            Path fragmentPath = new Path(encodedPath.substring(index + 3, encodedPath.length() - 2));
            IPath projectRelativePath = new Path(modelProjectLocation.lastSegment()).append((IPath)fragmentPath);
            CodeGen.findOrCreateContainer((IPath)projectRelativePath, (boolean)true, (IPath)modelProjectLocation, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            return projectRelativePath.makeAbsolute().toString();
        }
        if (rootLocation != null) {
            index = encodedPath.indexOf("/org.");
            if (index == -1) {
                index = encodedPath.indexOf("/com.");
            }
            if (index == -1) {
                index = encodedPath.indexOf("/javax.");
            }
            if (index != -1) {
                Path projectRelativePath = new Path(encodedPath.substring(index, encodedPath.length()));
                if ((index = encodedPath.indexOf("/", index + 5)) != -1) {
                    Path modelProjectLocation = new Path(String.valueOf(rootLocation) + "/" + encodedPath.substring(0, index));
                    CodeGen.findOrCreateContainer((IPath)projectRelativePath, (boolean)true, (IPath)modelProjectLocation, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    return projectRelativePath.makeAbsolute().toString();
                }
            }
        }
        return encodedPath;
    }

    public static IProject createEMFProject(IPath javaSource, IPath projectLocationPath, List referencedProjects, IProgressMonitor progressMonitor, int style) {
        return Generator.createEMFProject(javaSource, projectLocationPath, referencedProjects, progressMonitor, style, Collections.EMPTY_LIST);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IProject createEMFProject(IPath javaSource, IPath projectLocationPath, List referencedProjects, IProgressMonitor progressMonitor, int style, List pluginVariables) {
        String projectName = javaSource.segment(0);
        IProject project = null;
        try {
            try {
                boolean isInitiallyEmpty;
                IJavaProject javaProject;
                UniqueEList classpathEntries;
                block45: {
                    String[] natureIds;
                    classpathEntries = new UniqueEList();
                    progressMonitor.beginTask("", 10);
                    progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_CreatingEMFProject_message", new Object[]{projectName}));
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    project = workspace.getRoot().getProject(projectName);
                    if (!project.exists()) {
                        File projectFile;
                        IPath location = projectLocationPath;
                        if (location == null) {
                            location = workspace.getRoot().getLocation().append(projectName);
                        }
                        if ((projectFile = new File((location = location.append(".project")).toString())).exists()) {
                            projectFile.renameTo(new File(String.valueOf(location.toString()) + ".old"));
                        }
                    }
                    javaProject = JavaCore.create((IProject)project);
                    IProjectDescription projectDescription = null;
                    if (!project.exists()) {
                        projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
                        projectDescription.setLocation(projectLocationPath);
                        project.create(projectDescription, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    } else {
                        projectDescription = project.getDescription();
                        classpathEntries.addAll(Arrays.asList(javaProject.getRawClasspath()));
                    }
                    isInitiallyEmpty = classpathEntries.isEmpty();
                    if (referencedProjects.size() != 0 && (style & (EMF_PLUGIN_PROJECT_STYLE | EMF_EMPTY_PROJECT_STYLE)) == 0) {
                        projectDescription.setReferencedProjects(referencedProjects.toArray(new IProject[referencedProjects.size()]));
                        Iterator i = referencedProjects.iterator();
                        while (i.hasNext()) {
                            IProject referencedProject = (IProject)i.next();
                            IClasspathEntry referencedProjectClasspathEntry = JavaCore.newProjectEntry((IPath)referencedProject.getFullPath());
                            classpathEntries.add(referencedProjectClasspathEntry);
                        }
                    }
                    if ((natureIds = projectDescription.getNatureIds()) == null) {
                        natureIds = new String[]{"org.eclipse.jdt.core.javanature"};
                    } else {
                        boolean hasJavaNature = false;
                        boolean hasPDENature = false;
                        int i = 0;
                        while (true) {
                            if (i >= natureIds.length) {
                                if (!hasJavaNature) {
                                    String[] oldNatureIds = natureIds;
                                    natureIds = new String[oldNatureIds.length + 1];
                                    System.arraycopy(oldNatureIds, 0, natureIds, 0, oldNatureIds.length);
                                    natureIds[oldNatureIds.length] = "org.eclipse.jdt.core.javanature";
                                }
                                if (hasPDENature) break;
                                String[] oldNatureIds = natureIds;
                                natureIds = new String[oldNatureIds.length + 1];
                                System.arraycopy(oldNatureIds, 0, natureIds, 0, oldNatureIds.length);
                                natureIds[oldNatureIds.length] = "org.eclipse.pde.PluginNature";
                                break;
                            }
                            if ("org.eclipse.jdt.core.javanature".equals(natureIds[i])) {
                                hasJavaNature = true;
                            }
                            if ("org.eclipse.pde.PluginNature".equals(natureIds[i])) {
                                hasPDENature = true;
                            }
                            ++i;
                        }
                    }
                    projectDescription.setNatureIds(natureIds);
                    ICommand[] builders = projectDescription.getBuildSpec();
                    if (builders == null) {
                        builders = new ICommand[]{};
                    }
                    boolean hasManifestBuilder = false;
                    boolean hasSchemaBuilder = false;
                    int i = 0;
                    while (true) {
                        if (i >= builders.length) {
                            if (!hasManifestBuilder) {
                                ICommand[] oldBuilders = builders;
                                builders = new ICommand[oldBuilders.length + 1];
                                System.arraycopy(oldBuilders, 0, builders, 0, oldBuilders.length);
                                builders[oldBuilders.length] = projectDescription.newCommand();
                                builders[oldBuilders.length].setBuilderName("org.eclipse.pde.ManifestBuilder");
                            }
                            if (!hasSchemaBuilder) {
                                ICommand[] oldBuilders = builders;
                                builders = new ICommand[oldBuilders.length + 1];
                                System.arraycopy(oldBuilders, 0, builders, 0, oldBuilders.length);
                                builders[oldBuilders.length] = projectDescription.newCommand();
                                builders[oldBuilders.length].setBuilderName("org.eclipse.pde.SchemaBuilder");
                            }
                            projectDescription.setBuildSpec(builders);
                            project.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                            project.setDescription(projectDescription, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                            IProject sourceContainer = project;
                            if (javaSource.segmentCount() > 1 && !(sourceContainer = project.getFolder(javaSource.removeFirstSegments(1).makeAbsolute())).exists()) {
                                ((IFolder)sourceContainer).create(false, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                            }
                            if (isInitiallyEmpty) {
                                break;
                            }
                            break block45;
                        }
                        if ("org.eclipse.pde.ManifestBuilder".equals(builders[i].getBuilderName())) {
                            hasManifestBuilder = true;
                        }
                        if ("org.eclipse.pde.SchemaBuilder".equals(builders[i].getBuilderName())) {
                            hasSchemaBuilder = true;
                        }
                        ++i;
                    }
                    IClasspathEntry sourceClasspathEntry = JavaCore.newSourceEntry((IPath)javaSource);
                    Iterator i2 = classpathEntries.iterator();
                    while (true) {
                        if (!i2.hasNext()) break;
                        IClasspathEntry classpathEntry = (IClasspathEntry)i2.next();
                        if (!classpathEntry.getPath().isPrefixOf(javaSource)) continue;
                        i2.remove();
                    }
                    classpathEntries.add(0, sourceClasspathEntry);
                    IClasspathEntry jreClasspathEntry = JavaCore.newVariableEntry((IPath)new Path("JRE_LIB"), (IPath)new Path("JRE_SRC"), (IPath)new Path("JRE_SRCROOT"));
                    Iterator i3 = classpathEntries.iterator();
                    while (true) {
                        if (!i3.hasNext()) {
                            classpathEntries.add(jreClasspathEntry);
                            break;
                        }
                        IClasspathEntry classpathEntry = (IClasspathEntry)i3.next();
                        if (!classpathEntry.getPath().isPrefixOf(jreClasspathEntry.getPath())) continue;
                        i3.remove();
                    }
                }
                if ((style & EMF_EMPTY_PROJECT_STYLE) == 0) {
                    Iterator i;
                    if ((style & EMF_PLUGIN_PROJECT_STYLE) != 0) {
                        classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.requiredPlugins")));
                        i = classpathEntries.iterator();
                        while (i.hasNext()) {
                            IClasspathEntry classpathEntry = (IClasspathEntry)i.next();
                            if ((classpathEntry.getEntryKind() != 4 || "JRE_LIB".equals(classpathEntry.getPath().toString())) && classpathEntry.getEntryKind() != 2) continue;
                            i.remove();
                        }
                    } else {
                        Generator.addClasspathEntries((Collection)classpathEntries, "ECLIPSE_CORE_RUNTIME", "org.eclipse.core.runtime");
                        Generator.addClasspathEntries((Collection)classpathEntries, "ECLIPSE_CORE_RESOURCES", "org.eclipse.core.resources");
                        Generator.addClasspathEntries((Collection)classpathEntries, "EMF_COMMON", "org.eclipse.emf.common");
                        Generator.addClasspathEntries((Collection)classpathEntries, "EMF_ECORE", "org.eclipse.emf.ecore");
                        if ((style & EMF_XML_PROJECT_STYLE) != 0) {
                            Generator.addClasspathEntries((Collection)classpathEntries, "EMF_ECORE_XMI", "org.eclipse.emf.ecore.xmi");
                        }
                        if ((style & EMF_MODEL_PROJECT_STYLE) == 0) {
                            Generator.addClasspathEntries((Collection)classpathEntries, "EMF_EDIT", "org.eclipse.emf.edit");
                            if ((style & EMF_EDIT_PROJECT_STYLE) == 0) {
                                Generator.addClasspathEntries((Collection)classpathEntries, "ECLIPSE_SWT", "org.eclipse.swt");
                                Generator.addClasspathEntries((Collection)classpathEntries, "ECLIPSE_JFACE", "org.eclipse.jface");
                                Generator.addClasspathEntries((Collection)classpathEntries, "ECLIPSE_UI_VIEWS", "org.eclipse.ui.views");
                                Generator.addClasspathEntries((Collection)classpathEntries, "ECLIPSE_UI_EDITORS", "org.eclipse.ui.editors");
                                Generator.addClasspathEntries((Collection)classpathEntries, "ECLIPSE_UI_IDE", "org.eclipse.ui.ide");
                                Generator.addClasspathEntries((Collection)classpathEntries, "ECLIPSE_UI_WORKBENCH", "org.eclipse.ui.workbench");
                                Generator.addClasspathEntries((Collection)classpathEntries, "EMF_COMMON_UI", "org.eclipse.emf.common.ui");
                                Generator.addClasspathEntries((Collection)classpathEntries, "EMF_EDIT_UI", "org.eclipse.emf.edit.ui");
                                if ((style & EMF_XML_PROJECT_STYLE) == 0) {
                                    Generator.addClasspathEntries((Collection)classpathEntries, "EMF_ECORE_XMI", "org.eclipse.emf.ecore.xmi");
                                }
                            }
                        }
                        if (pluginVariables != null) {
                            i = pluginVariables.iterator();
                            while (i.hasNext()) {
                                String id;
                                String name;
                                Object variable = i.next();
                                if (variable instanceof IClasspathEntry) {
                                    classpathEntries.add(variable);
                                    continue;
                                }
                                if (!(variable instanceof String)) continue;
                                String pluginVariable = (String)variable;
                                int index = pluginVariable.indexOf("=");
                                if (index == -1) {
                                    name = pluginVariable.replace('.', '_').toUpperCase();
                                    id = pluginVariable;
                                } else {
                                    name = pluginVariable.substring(0, index);
                                    id = pluginVariable.substring(index + 1);
                                }
                                Generator.addClasspathEntries((Collection)classpathEntries, name, id);
                            }
                        }
                    }
                }
                javaProject.setRawClasspath(classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                if (isInitiallyEmpty) {
                    javaProject.setOutputLocation((IPath)new Path("/" + javaSource.segment(0) + "/runtime"), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                CodeGenEcorePlugin.INSTANCE.log(exception);
            }
        }
        catch (Throwable throwable) {
            Object var24_35 = null;
            progressMonitor.done();
            throw throwable;
        }
        {
            Object var24_36 = null;
        }
        progressMonitor.done();
        return project;
    }

    public static void addClasspathEntries(Collection classpathEntries, String pluginID) throws Exception {
        Generator.addClasspathEntries(classpathEntries, null, pluginID);
    }

    public static void addClasspathEntries(Collection classpathEntries, String variableName, String pluginID) throws Exception {
        block14: {
            try {
                Bundle bundle = Platform.getBundle((String)pluginID);
                String requires = (String)bundle.getHeaders().get("Bundle-ClassPath");
                ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)requires);
                int i = 0;
                int count = 0;
                if (i >= elements.length) break block14;
                ManifestElement element = elements[i];
                try {
                    URL url = bundle.getEntry(element.getValue());
                    Path path = new Path(Platform.asLocalURL((URL)url).getFile());
                    if (!"nl1.jar".equals(path.lastSegment())) {
                        String shortName = path.removeFileExtension().lastSegment();
                        if (variableName == null) {
                            classpathEntries.add(JavaCore.newLibraryEntry((IPath)path, null, null));
                        } else if (count == 0 && pluginID.equals("org.apache.xerces")) {
                            String mangledName = String.valueOf(variableName) + "_API";
                            if (!path.equals((Object)JavaCore.getClasspathVariable((String)mangledName))) {
                                JavaCore.setClasspathVariable((String)mangledName, (IPath)path, null);
                            }
                            classpathEntries.add(JavaCore.newVariableEntry((IPath)new Path(mangledName), null, null));
                        } else if (!(count == 1 && pluginID.equals("org.eclipse.ui.ide") || shortName == null || shortName.endsWith("-pi"))) {
                            if (!path.equals((Object)JavaCore.getClasspathVariable((String)variableName))) {
                                JavaCore.setClasspathVariable((String)variableName, (IPath)path, null);
                            }
                            classpathEntries.add(JavaCore.newVariableEntry((IPath)new Path(variableName), null, null));
                        }
                        ++count;
                    }
                }
                catch (MalformedURLException exception) {
                    throw new JETException((Throwable)exception);
                }
                catch (JavaModelException exception) {
                    throw new JETException((Throwable)exception);
                }
                catch (IOException exception) {
                    throw new JETException((Throwable)exception);
                }
            }
            catch (BundleException exception) {
                throw new JETException((Throwable)exception);
            }
        }
    }

    public void printStatus(String prefix, IStatus status) {
        System.err.print(prefix);
        System.err.println(status.getMessage());
        IStatus[] children = status.getChildren();
        String childPrefix = "  " + prefix;
        int i = 0;
        while (i < children.length) {
            this.printStatus(childPrefix, children[i]);
            ++i;
        }
    }

    public static String validName(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (JavaConventions.validateIdentifier((String)name).isOK()) {
            return name;
        }
        StringBuffer result = new StringBuffer();
        if (Character.isJavaIdentifierStart(name.charAt(0))) {
            result.append(name.charAt(0));
        } else {
            result.append('_');
            if (Character.isJavaIdentifierPart(name.charAt(0))) {
                result.append(name.charAt(0));
            }
        }
        int i = 1;
        while (i < name.length()) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) {
                result.append(name.charAt(i));
            }
            ++i;
        }
        return result.length() == 0 ? "_" : result.toString();
    }

    public static void setSDODefaults(GenModel genModel) {
        genModel.setRootExtendsInterface("");
        genModel.setRootImplementsInterface("org.eclipse.emf.ecore.sdo.InternalEDataObject");
        genModel.setRootExtendsClass("org.eclipse.emf.ecore.sdo.impl.EDataObjectImpl");
        genModel.setFeatureMapWrapperInterface("commonj.sdo.Sequence");
        genModel.setFeatureMapWrapperInternalInterface("org.eclipse.emf.ecore.sdo.util.ESequence");
        genModel.setFeatureMapWrapperClass("org.eclipse.emf.ecore.sdo.util.BasicESequence");
        genModel.setSuppressEMFTypes(true);
        genModel.getModelPluginVariables().add((Object)"EMF_COMMONJ_SDO=org.eclipse.emf.commonj.sdo");
        genModel.getModelPluginVariables().add((Object)"EMF_ECORE_SDO=org.eclipse.emf.ecore.sdo");
        genModel.getStaticPackages().add((Object)"http://www.eclipse.org/emf/2003/SDO");
    }
}

