#
# Copyright (C) 2004 Tenable Network Security
#

if(description)
{
 script_id(12108);
 script_bugtraq_id(9872);

 script_version("$Revision: 1.2 $");

 name["english"] = "Multiple Overflows in WS_FTP client";

 script_name(english:name["english"]);

 desc["english"] = "
The remote host has a version of the WS_FTP client which is vulnerable to 
multiple remote exploits.  
An attacker, exploiting these bugs would be able to access confidential 
data on this system.

To exploit this flaw, an attacker would need to lure a user of this host
to visit a rogue FTP server, by inviting him by email, AIM or any other
mean.

Solution : Upgrade to the newest version of the WS_FTP client 
See also : http://www.ipswitch.com/
Risk factor : High";


 script_description(english:desc["english"]);

 summary["english"] = "IPSWITCH WS_FTP client overflow detection";

 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);

 script_dependencies("netbios_name_get.nasl",
                     "smb_login.nasl","smb_registry_access.nasl");
 script_require_keys("SMB/name", "SMB/login", "SMB/password",
                     "SMB/domain","SMB/transport");

 script_require_ports(139, 445);
 exit(0);
}

# start script

include("smb_nt.inc");
include("smb_file_funcs.inc");


# file location is *not* stored in registry...

rootfile = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion", item:"ProgramFilesDir");

if(!rootfile) exit(0);

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1", string:rootfile);
filenam = rootfile + '\\WS_FTP\\WSFTP32.DLL';

myread = smb_file_read(file:filenam, count:4096, offset:28800);
if (egrep(string:myread, pattern:"^ERROR")) exit(0);

myread = str_replace(find:raw_string(0), replace:"", string:myread);
if (strstr(myread, "User-Agent: WS_FTP/"))  {
    version = ereg_replace(pattern:"User-Agent: WS_FTP/(([0-9]\.)+[0-9]*).*", replace:"\1", string:myread);
    set_kb_item(name:"ws_ftp_client/version", value:version);
    # all versions through Ipswitch WS_FTP Pro 8.0.0.3
    if (egrep(string:myread, pattern:".*([0-7]\.[0-9]\.[0-9]|8\.0\.0\.[0-3][^0-9])")) security_hole(port);
}

