#
# (C) Tenable Network Security
#
#
# Thanks to Greg Hoglund <hoglund@hbgary.com> for suggesting this.
#

if(description)
{
 script_id(12028);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "WindowsUpdate disabled";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host does not have Windows Update enabled. 

Enabling WindowsUpdate will ensure that the remote Windows host has
all the latest Microsoft Patches installed.

Solution : Enable Windows Update on this host
See also : http://www.microsoft.com/security/protect/";



 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the value of AUState";
 script_summary(english:summary["english"]);
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("netbios_name_get.nasl",
 		     "smb_login.nasl", "smb_registry_access.nasl");
 script_require_keys("SMB/transport", "SMB/name", "SMB/login", "SMB/password", "SMB/registry_access");
 script_require_ports(139, 445);
 exit(0);
}

include("smb_nt.inc");


key = "SOFTWARE\Microsoft\Windows\CurrentVersion\WindowsUpdate\Auto Update";
item = "AUState";
value = registry_get_dword(key:key, item:item);

if ( value == NULL ) exit(0);

# AUState = 7 if disabled
if ( value == 0x07 ) security_note(kb_smb_transport());
