#
# (C) Tenable Network Security
#

if(description)
{
 script_id(12092);
 script_bugtraq_id(9827);
 script_cve_id("CAN-2004-0121");
 if(defined_func("script_xref"))script_xref(name:"IAVA", value:"2004-B-0004");

 
 script_version("$Revision: 1.3 $");

 name["english"] = "Vulnerability in Outlook could allow code execution (828040)";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of outlook which is vulnerable to a bug 
which may allow Internet Explorer to execute script code in the Local Machine
zone and therefore let an attacker execute arbitrary programs on this host.

To exploit this bug, an attacker would need to send an special HTML message to
a user of this host.

Solution : See http://www.microsoft.com/technet/security/bulletin/ms04-009.mspx
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the version of OutLook.exe";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("netbios_name_get.nasl",
 		     "smb_login.nasl","smb_registry_access.nasl");
 script_require_keys("SMB/name", "SMB/login", "SMB/password",
		     "SMB/WindowsVersion",
		     "SMB/registry_access");

 script_require_ports(139, 445);
 exit(0);
}


include("smb_nt.inc");


rootfile = registry_get_sz(key:"SOFTWARE\Microsoft\Office\10.0\Outlook\InstallRoot", item:"Path");
if(!rootfile)
{
 exit(0);
}
else
{
 share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:rootfile);
 outlook =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1outlook.exe", string:rootfile);
}





name 	=  kb_smb_name();
login	=  kb_smb_login();
pass  	=  kb_smb_password();
domain 	=  kb_smb_domain();
port    =  kb_smb_transport();
if(!port) port = 139;



if(!get_port_state(port))exit(0);

soc = open_sock_tcp(port);
if(!soc)exit(0);


if ( port == 139 )
{
r = smb_session_request(soc:soc, remote:name);
if(!r)exit(0);
}

prot = smb_neg_prot(soc:soc);
if(!prot)exit(0);

r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain, prot:prot);
if(!r)exit(0);

uid = session_extract_uid(reply:r);



r = smb_tconx(soc:soc, name:name, uid:uid, share:share);
tid = tconx_extract_tid(reply:r);
if(!tid)exit(0);

fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:outlook);
if(fid)
{
 v = GetFileVersion(socket:soc, uid:uid, tid:tid, fid:fid);
 if ( ! v ) exit(0);
 z  = split(v, sep:".", keep:FALSE);
 if ( int(z[0]) == 10 && int(z[1]) == 0 && int(z[2]) < 5709 ) security_hole(port);

}
