#
# This script is (C) Tenable Network Security
#
#

if(description)
{
 script_id(15543);
 script_bugtraq_id(11497);
 script_version ("$Revision: 1.1 $");

 name["english"] = "Serendipity HTTP Response Splitting Vulnerability";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running Serendipity, a weblog written in PHP.

The remote version of this software is vulnerable to a HTTP response
splitting vulnerability which may allow an attacker to perform a
cross site scripting attack against the remote host.

Solution : Upgrade to Serendipity 0.7.0rc1 or newer
Risk factor : Medium";




 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the presence of Serendipity";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security",
		francais:"Ce script est Copyright (C) 2004 Tenable Network Security");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#


include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);



function check(loc)
{
 req = http_get(item:string(loc, "/index.php"), port:port);
 r = http_keepalive_send_recv(port:port, data:req, bodyonly:1);
 if( r == NULL )exit(0);
 if( egrep(pattern:'<meta name="Powered-By" content="Serendipity v\\.0\\.([0-6][^0-9]|7-b).*', string:r) )
 {
 	security_warning(port);
	exit(0);
 }
}




foreach dir ( cgi_dirs() )
{
 check(loc:dir);
}
