#
# Copyright (C) 2004 Tenable Network Security 
#
#

if(description)
{
 script_id(12000);
 script_version("$Revision: 1.5 $");

 name["english"] = "SAHAGENT detection";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is using the SAHAGENT program.  
You should ensure that:
- the user intended to install SAHAGENT (it is sometimes silently installed)
- the use of SAHAGENT matches your Corporate mandates and Security Policies.

To remove this sort of software, you may wish to check out ad-aware or spybot. 

See also : http://www.safersite.com/PestInfo/s/sahagent.asp 

Solution : Uninstall this software
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "SAHAGENT detection";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies( "smb_registry_full_access.nasl");
 script_require_keys("SMB/registry_full_access");

 script_require_ports(139, 445);
 exit(0);
}


# start the script
if ( ! get_kb_item("SMB/registry_full_access") ) exit(0);

path[0] = "software\classes\clsid\{30402ff4-3e71-4a1c-9b4b-1cd3486a9fb2}";
path[1] = "software\classes\interface\{4828c95f-c5db-4ab6-a945-8d8ec44b98a8}";
path[2] = "software\classes\interface\{4e570f74-deee-4fcf-b960-feefa4b8c6fc}";
path[3] = "software\microsoft\code store database\distribution units\{30402ff4-3e71-4a1c-9b4b-1cd3486a9fb2}";
path[4] = "software\microsoft\windows\currentversion\moduleusage\c:/winnt/downloaded program files/lsp_.dll\{30402ff4-3e71-4a1c-9b4b-1cd3486a9fb2}";
path[5] = "software\microsoft\windows\currentversion\moduleusage\c:/winnt/downloaded program files/sahagent_.exe\{30402ff4-3e71-4a1c-9b4b-1cd3486a9fb2}";
path[6] = "software\microsoft\windows\currentversion\moduleusage\c:/winnt/downloaded program files/sahdownloader_.exe\{30402ff4-3e71-4a1c-9b4b-1cd3486a9fb2}";
path[7] = "software\microsoft\windows\currentversion\moduleusage\c:/winnt/downloaded program files/sahuninstall_.exe\{30402ff4-3e71-4a1c-9b4b-1cd3486a9fb2}";
path[8] = "software\microsoft\windows\currentversion\moduleusage\c:/winnt/downloaded program files/sporder_.dll\{30402ff4-3e71-4a1c-9b4b-1cd3486a9fb2}";
path[9] = "software\microsoft\windows\currentversion\moduleusage\c:/winnt/downloaded program files/webinstaller.dll\{30402ff4-3e71-4a1c-9b4b-1cd3486a9fb2}";
path[10] = "software\microsoft\windows\currentversion\moduleusage\c:/winnt/downloaded program files/xmlparse_.dll\{30402ff4-3e71-4a1c-9b4b-1cd3486a9fb2}";
path[11] = "software\microsoft\windows\currentversion\moduleusage\c:/winnt/downloaded program files/xmltok_.dll\{30402ff4-3e71-4a1c-9b4b-1cd3486a9fb2}";
path[12] = "software\microsoft\windows\currentversion\moduleusage\c:/winnt/system32/mfc42.dll\{30402ff4-3e71-4a1c-9b4b-1cd3486a9fb2}";
path[13] = "software\microsoft\windows\currentversion\moduleusage\c:/winnt/system32/msvcrt.dll\{30402ff4-3e71-4a1c-9b4b-1cd3486a9fb2}";
path[14] = "software\microsoft\windows\currentversion\moduleusage\c:/winnt/system32/olepro32.dll\{30402ff4-3e71-4a1c-9b4b-1cd3486a9fb2}";
path[15] = "software\microsoft\windows\currentversion\run\sahagent";
path[16] = "software\vgroup";






global_var handle;

include("smb_nt.inc");
x_name = kb_smb_name();
if(!x_name)exit(0);

_smb_port = kb_smb_transport();
if(!_smb_port)exit(0);

if(!get_port_state(_smb_port)) exit(0);
login = kb_smb_login();
pass  = kb_smb_password();
domain = kb_smb_domain();

if(!login)login = "";
if(!pass) pass = "";

          
soc = open_sock_tcp(_smb_port);
if(!soc) exit(0);

#
# Request the session
# 
r = smb_session_request(soc:soc,  remote:x_name);
if(!r) { close(soc); exit(0); }

#
# Negociate the protocol
#
prot = smb_neg_prot(soc:soc);
if(!prot){ close(soc); exit(0); }


r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain, prot:prot);
if(!r){ close(soc); exit(0); }
uid = session_extract_uid(reply:r);

r = smb_tconx(soc:soc, name:x_name, uid:uid, share:"IPC$");
tid = tconx_extract_tid(reply:r);
if(!tid){ close(soc); exit(0); }


r = smbntcreatex(soc:soc, uid:uid, tid:tid, name:"\winreg");
if(!r){ close(soc); exit(0);}
pipe = smbntcreatex_extract_pipe(reply:r);

r = pipe_accessible_registry(soc:soc, uid:uid, tid:tid, pipe:pipe);
if(!r){ close(soc); exit(0); }
handle = registry_open_hklm(soc:soc, uid:uid, tid:tid, pipe:pipe);
if ( ! handle ) exit(0);


for (i=0; path[i]; i++) {
       key_h = registry_get_key(soc:soc, uid:uid, tid:tid, pipe:pipe, key:path[i], reply:handle);
       if(key_h != NULL) {security_hole(kb_smb_transport()); exit(0); }
}

close(soc);
