#
# Copyright (C) 2004 Tenable Network Security
#

if(description)
{
 script_id(12111);
 script_version("$Revision: 1.2 $");

 name["english"] = "PhatBOT detection";

 script_name(english:name["english"]);

 desc["english"] = "
The remote systems appears to have PhatBOT installed.  
This program allows the machine to be controlled via a P2P 
network.  PhatBOT is extremely sophisticated and allows the 
remote attacker to use the victim machine to perform various
actions.

Solution : Remove PhatBOT immediately 
See also : http://www.lurhq.com/phatbot.html
Risk factor : High";


 script_description(english:desc["english"]);

 summary["english"] = "PhatBOT detection";

 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);

 script_dependencies("netbios_name_get.nasl",
                     "smb_login.nasl","smb_registry_access.nasl");
 script_require_keys("SMB/name", "SMB/login", "SMB/password",
                     "SMB/domain","SMB/transport");

 script_require_ports(139, 445);
 exit(0);
}

# start script
include("smb_nt.inc");


path[0] = "Software\Microsoft\Windows\CurrentVersion\Run\Generic Service Process";
path[1] = "Software\Microsoft\Windows\CurrentVersion\RunServices\Generic Service Process";

if ( ! get_kb_item("SMB/registry_access") ) exit(0);

for (i=0; path[i]; i++) {
    val = registry_key_exists(key:path[i]);
    if (val != NULL) {
        security_hole(kb_smb_transport());
        exit(0);
    }
}



