#
# (C) Tenable Network Security
#

if (description)
{
	script_id(12047);
	script_bugtraq_id(9587);
 	script_version ("$Revision: 1.4 $");
	script_name(english: "Oracle timezone overflow");
	script_description(english:"
The remote Oracle Database, according to its version number, is vulnerable 
to a buffer overflow in the query SET TIME_ZONE.

An attacker with a database account may use this flaw to gain the control
on the whole database, or even to obtain a shell on this host.

Solution : Upgrade to Oracle 9.2.0.3 - http://metalink.oracle.com
See Also : http://www.nextgenss.com/advisories/ora_time_zone.txt
Risk factor : High");

	script_summary(english: "Checks the version of the remote database");

	script_category(ACT_GATHER_INFO);
	script_family(english: "Gain a shell remotely");
	script_copyright(english: "This script is (C) 2004 Tenable Network Security");
	script_dependencie("oracle_tnslsnr_version.nasl");
	script_require_ports(1521, 1541);
	exit(0);
}


port = 1521;
version = get_kb_item("oracle_tnslsnr/1521/version");
if(!version){version = get_kb_item("oracle_tnslsnr/1541/version"); port = 1541; }
if(!version)exit(0);

if(ereg(pattern:".*Version (9\.0\.[0-1]|9\.2\.0\.[0-2]).*", string:version))security_hole(port);
