#
# This script was written by Renaud Deraison
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(11578);
 script_bugtraq_id(7450);
 script_version("$Revision: 1.4 $");

 name["english"] = "Opera remote heap corruption vulnerability";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is using Opera - an alternative web browser.

The version installed has a buffer overflow condition in the code
which handles the file extensions of the remote web pages.

To exploit them, an attacker would need to set up a rogue web site, then
lure a user of this host visit it using Opera. He would then be able
to execute arbitrary code on this host.

Solution : None at this time
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the version of Opera.exe";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2003 Renaud Deraison");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("opera_multiple_flaws.nasl");
 script_require_keys("Host/Windows/Opera/Version");
 exit(0);
}


v = get_kb_item("Host/Windows/Opera/Version");
if(strlen(v))
{
  report = "
We have determined that you are running Opera v." + v + ". This version
has a buffer overflow condition in the code which handles the file extensions 
of the remote web pages which may allow an attacker to execute arbitrary
code on this host.

To exploit these flaws, an attacker would need to set up a rogue website
and lure a user of this host visit it using Opera. He would then be able
to execute arbitrary code on this host.

Solution : Upgrade to version 7.03 or newer
Risk factor : High";

 # minor =  ereg_replace(pattern:"[0-9]\.([0-9]*)$", string:v, replace:"\1");
 #  major =  ereg_replace(pattern:"([0-9])\.[0-9]*$", string:v, replace:"\1");
 # if(int(major) < 7 || (int(major) == 7 && int(minor) < 3))security_hole(port:port, data:report);
 security_hole(port:port, data:report);
}
