#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12621);
 script_bugtraq_id(9758);
 script_version ("$Revision: 1.3 $");
 name["english"] = "FreeBSD Ports: uudeview < 0.5.20";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of uudeview, uulib and/or xdeview installed.

uudeview is a program for decoding and encoding files in various formats
(UU, Base64, BinHex, and more). There are two overflows in this software which
may allow an attacker to execute arbitrary code on this host.

To exploit these flaws, an attacker would need to send a specially crafted 
file to a victim on the remote host and would need to wait for him to 
decode the file using uudeview or xdeview (or any program using the uulib).


Solution : http://www.vuxml.org/freebsd/6c7661ff-7912-11d8-9645-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of various packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^(uudeview|uulib|xdeview)-", string:pkgs);
lines  = split(package, sep:'\n', keep:0);
foreach package (lines)
{
if ( pkg_cmp(pkg:package, reference:"uudeview-0.5.20") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
}
