#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14440);
 script_bugtraq_id(11015);
 script_version ("$Revision: 1.3 $");
 if ( defined_func("script_xref") ) {
	script_xref(name:"OSVDB", value:"9116");
  }
 name["english"] = "FreeBSD Ports: nss < 3.9.2";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has a version of nss which is older than 3.9.2

NSS is the Mozilla Network Security Services Library, a set of libraries 
designed to support the developement of security-enabled client/server 
application.

There is a flaw in the remote version of this library, in the SSLv2
handling code, which may allow an attacker to cause a heap overflow and
therefore execute arbitrary commands on the remote host. To exploit this
flaw, an attacker would need to send a malformed SSLv2 'hello' message
to the remote service.

Solution : http://www.vuxml.org/freebsd/207f8ff3-f697-11d8-81b0-000347a4fa7d.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the nss package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^nss-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"nss-3.9.2") < 0 ) 
	security_hole(0);
