#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14339);
 script_bugtraq_id(10969);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2004-0457");
 name["english"] = "FreeBSD Ports : MySQL-scripts mysqlhotcopy";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the mysql-scripts package
installed.

The utility 'mysqlhotcopy' which comes with this package creates 
temporary files insecurely. A local user may use this problem to
overwrite files he would otherwise not have access to.

Solution : http://www.vuxml.org/freebsd/0c4d5973-f2ab-11d8-9837-000c41e2cdad.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mysql-scripts package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");

pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^mysql-scripts-3\.", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"mysql-scripts-3.23.58") <= 0 ) 
        {
        security_warning(0);
        exit(0);
        }
package = egrep(pattern:"^mysql-scripts-4\.0", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"mysql-scripts-4.0.20") <= 0 ) 
        {
        security_warning(0);
        exit(0);
        }
package = egrep(pattern:"^mysql-scripts-4\.1", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"mysql-scripts-4.1.3") <= 0 ) 
        {
        security_warning(0);
        exit(0);
        }
package = egrep(pattern:"^mysql-scripts-5\.0", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"mysql-scripts-5.0.0_1") <= 0 ) 
        {
        security_warning(0);
        exit(0);
        }
