#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12577);
 script_bugtraq_id(9129);
 script_version ("$Revision: 1.4 $");
 script_cve_id("CAN-2003-0973");
 name["english"] = "FreeBSD Ports : mod_python";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the mod_python package installed.

mod_python is an embeded python interpreter for the Apache webserver.
There is a vulnerability in the remote version of mod_python which
may allow an attacker to disable the remote web server remotely, provided
it is running.

Solution : http://www.vuxml.org/freebsd/1a448eb7-6988-11d8-873f-0020ed76ef5a.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mod_python package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^mod_python-2\.7", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"mod_python-2.7.10") < 0 ) 
	{
	security_warning(0);
	exit(0);
	}
package = egrep(pattern:"^mod_python-3", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"mod_python-3.0.4") < 0 ) 
	{
	security_warning(0);
	exit(0);
	}
