#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12574);
 script_bugtraq_id(9692, 9836);
 script_version ("$Revision: 1.4 $");
 script_cve_id("CAN-2004-0104", "CAN-2004-0150");
 name["english"] = "FreeBSD Ports : metamail < 2.7_2";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of metamail installed.

metamail is an implementation of MIME and is used by various utilities.
There is a bug in the remote version of this software which may allow an attacker
to execute arbitrary code on this host.

To exploit this flaw, an attacker would need to send a specially crafted 
email message which would be processed by metamail.

Solution : http://www.vuxml.org/freebsd/a20082c3-6255-11d8-80e3-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the metamail package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
package = egrep(pattern:"^metamail-", string:pkgs);

if ( package && pkg_cmp(pkg:package, reference:"metamail-2.7_2") < 0 ) 
	security_hole(0);
