#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12573);
 script_bugtraq_id(8658);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-1023");
 name["english"] = "FreeBSD Ports: mc < 4.6.0_9";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of mc installed.

mc (Midnight Commander) is a text-based file manager. There is a bug in the
remote version of this software in the way it resolves symbolic links within
a file archive (tar or cpio).

An attacker could exploit this flaw to execute arbitrary code on the remote
host by sending a specially crafted tar or cpio archive to a victim on the
remote host and wait for him to process it using mc.

Solution : http://www.vuxml.org/freebsd/322d4ff6-85c3-11d8-a41f-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mc package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^mc-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"mc-4.6.0_9") < 0 ) security_hole(0);
