#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12567);
 script_bugtraq_id(9336);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0965");
 name["english"] = "FreeBSD Ports : mailman < 2.1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has the package mailman installed.

mailman is a web-enabled mailing list manager. There is a denial of service
issue in the remote version of mailman which may allow an attacker to 
disable the mailing lists remotely.

Solution : http://www.vuxml.org/freebsd/b0e76877-67a8-11d8-80e3-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mailman package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
package = egrep(pattern:"^mailman-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"mailman-2.1") < 0 ) 
	security_hole(0);
