#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15501);
 script_version ("$Revision: 1.1 $");
 name["english"] = "FreeBSD Ports : icecast < 1.3.12_2";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has the following package installed :
	icecast < 1.3.12_2


Icecast is a streaming mp3 audio server. 

There is a flaw in the remote version of this software which may allow
an attacker to execute a cross site scripting attack against the remote
host.

Solution : http://www.vuxml.org/freebsd/b2cfb400-1df0-11d9-a859-0050fc56d258.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the icecast package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^icecast-[0-9]", string:pkgs);
if (package && pkg_cmp(pkg:package, reference:"icecast-1.3.12_2") < 0 )
	security_warning(0);
