#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12546);
 script_bugtraq_id(10609);
 script_version ("$Revision: 1.3 $");
 name["english"] = "FreeBSD Ports : gnats < 3.113.1_9";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of gnats installed (older than 3.113.1_9)

gnats is a bug tracking system. There is a flaw in the remote version of
this software which may be exploited by an attacker to gain superuser privileges
on the remote host.

Solution : http://www.vuxml.org/freebsd/4d837296-cc28-11d8-a54c-02e0185c0b53.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gnats package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
package = egrep(pattern:"^gnats-3", string:pkgs);

if ( package && pkg_cmp(pkg:package, reference:"gnats-3.113.1_10") < 0 ) 
	security_hole(0);
