#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12544);
 script_bugtraq_id(10451);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0522");
 name["english"] = "FreeBSD Ports: gallery < 1.4.3.2";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has a version of gallery installed which is older than 1.4.3.2.

Gallery is a set of PHP scripts to manage collections of photos with a web
interface. There is a flaw in this version which may allow an attacker to bypass
the authentication mecanism of this software by making requests including
the options GALLERY_EMBEDDED_INSIDE and GALLERY_EMBEDDED_INSIDE_TYPE.


Solution : http://www.vuxml.org/freebsd/253ea131-bd12-11d8-b071-00e08110b673.html
Risk factor : Low";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gallery package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^gallery-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"gallery-1.4.3.2") < 0 ) 
	security_warning(0);
