#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12543);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2004-0005", "CAN-2004-0006", "CAN-2004-0007", "CAN-2004-0008");

 name["english"] = "FreeBSD Ports : GAIM <= 0.76";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the GAIM package which is older
than 0.76_1.

Gaim, an instant messenger client, contains a number of bugs which may
allow an attacker to execute arbitrary code on the remote host.

To exploit these bugs, an attacker would need to send malformed instant
messages to a user of this host.

Solution : http://www.vuxml.org/freebsd/6fd02439-5d70-11d8-80e3-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gaim package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
package = egrep(pattern:"^gaim-", string:pkgs);

if ( package && pkg_cmp(pkg:package, reference:"gaim-0.76_1") < 0 ) 
	security_hole(0);
