#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12538);
 script_bugtraq_id(10291);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0400");
 name["english"] = "FreeBSD Ports: exim < 4.33+20_1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the exim package which is older
than 4.33+20_1.

exim is a mail transport agent. There is a bug in the remote version of this
software, when the option 'verify' is set to 'header_syntax', which may make
is vulnerable to remote buffer overflow.

Solution : http://www.vuxml.org/freebsd/5f29c2e4-9f6a-11d8-abbc-00e08110b673.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the exim packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^exim-", string:pkgs);
lines = split(package, sep:'\n', keep:0);
foreach package (lines )
{
if ( pkg_cmp(pkg:package, reference:"exim-4.33+20_1") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
}
