#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12535);
 script_bugtraq_id(8420, 8421);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0781", "CAN-2003-0782");
 name["english"] = "FreeBSD Ports: ecartis < 1.0.0s20030814_1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the ecartis package which is
older than 1.0.0s20030814_1.

ecartis is a mailing list manager. There are several buffer overflows in
the remote version of this package which may allow an attacker to execute
arbitrary code on the remote host, or to disclose the mailing list passwords.

Solution : http://www.vuxml.org/freebsd/3e9be8c4-8192-11d8-9645-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ecartis package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^ecartis-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"ecartis-1.0.0s20030814_1") < 0 ) 
	security_hole(0);
