#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12534);
 script_bugtraq_id(10590, 10591);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0460");
 name["english"] = "FreeBSD Ports: isc-dhcp3 < 3.0.1.r14";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has a version of isc-dhpc3 (relay or server) installed i
which is older than 3.0.1.r14 


There is a buffer overflow in the logging mecanism of the remote software
which may allow an attacker to execute arbitrary code on the remote host
with the superuser privileges.

Solution : http://www.vuxml.org/freebsd/7a9d5dfe-c507-11d8-8898-000d6111a684.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the isc-dhcp3 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^isc-dhcp3-relay-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"isc-dhcp3-relay-3.0.1.r14") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
package = egrep(pattern:"^isc-dhcp3-server-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"isc-dhcp3-server-3.0.1.r14") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
