#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15495);
 script_bugtraq_id(11347);
 script_version ("$Revision: 1.1 $");
 name["english"] = "FreeBSD Ports : cyrus-sasl <= 1.5.28_3 or cyrus-sasl < 2.1.19";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has a version of the 'cyrus-sasl' package which is older than 
version 1.5.28_3 or 2.1.19.

cyrus-sasl is a RFC 2222 SASL (Simple Authentication and Security Layer) 
framework.

The remote version of this software may allow a local attacker to gain
root privileges on the remote host or a remote attacker to execute arbitrary
code on the remote host.

Solution : http://www.vuxml.org/freebsd/92268205-1947-11d9-bc4a-000c41e2cdad.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the cyrus-sasl package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");

pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^cyrus-sasl-[01]", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"cyrus-sasl-1.5.28_3") <= 0 ) 
        {
        security_hole(0);
        exit(0);
        }
package = egrep(pattern:"^cyrus-sasl-2", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"cyrus-sasl-2.1.19") <= 0 ) 
        {
        security_hole(0);
        exit(0);
        }
