#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14282);
 script_bugtraq_id(10499);
 script_cve_id("CAN-2004-0414","CAN-2004-0416","CAN-2004-0417","CAN-2004-0418","CAN-2004-0778");
 script_version ("$Revision: 1.3 $");

 name["english"] = "FreeBSD Multiple CVS vulnerabilities";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running an older version of CVS.

This version of CVS is vulnerable to multiple remote overflows.  Exploit 
code has been released which targets at least one of these overflows.  An
attacker, exploiting these flaws, would need network access to the CVS
server.  

Solution : http://www.vuxml.org/freebsd/d2102505-f03d-11d8-81b0-000347a4fa7d.html 
 
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "FreeBSD check for multiple CVS vulnerabilities";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
package = egrep(pattern:"^cvs+ipv6-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"cvs+ipv6-1.11.17") < 0 )
        security_hole(0);

