#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14342);
 script_bugtraq_id(10976);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0777");
 name["english"] = "FreeBSD Ports : courier-imap < 3.0.7,1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of the courier-imap package which is older
than 3.0.7,1

Courier-imap is a IMAP (and POP3) server that provides access to Maildir mailboxes.

There is a format string bug in the remote version of this package which
may allow an attacker to execute arbitrary code on the remote host if 
Courier-IMAP is run in debug mode.

Solution : http://www.vuxml.org/freebsd/616cf823-f48b-11d8-9837-000c41e2cdad.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the courier-imap package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");

pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^courier-imap-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"courier-imap-3.0.7,1") < 0 ) 
        {
        security_hole(0);
        exit(0);
        }
