#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15510);
 script_bugtraq_id(11312);
 script_version ("$Revision: 1.1 $");
 name["english"] = "FreeBSD Ports : cacti < 0.8.6";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has the following package installed :
	cacti < 0.8.6

cacti is a web-driven graphing system for RRDTool.

The remote version of this software is vulnerable to a SQL injection
attack which may allow an attacker to change the password of arbitrary
cacti users.

Solution : http://www.vuxml.org/freebsd/ca543e06-207a-11d9-814e-0001020eed82.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the cacti package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^cacti-0\.", string:pkgs);
if (package && pkg_cmp(pkg:package, reference:"cacti-0.8.6") < 0 )
	security_hole(0);
