#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14761);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CAN-2004-0747", "CAN-2004-0786");
 name["english"] = "FreeBSD Ports : Apache < 2.0.50_3";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the Apache 2.0 package which is
older than 2.0.50_3.

There are two security issues in the remote version of this package :

- There is a buffer overflow condition when the function ap_resolve_env()
expands the ${ENVVAR} constructs set in .htaccess files. A local attacker
may exploit this flaw to gain the privileges of the httpd process.

- There is a buffer overflow condition in the function apr_uri_parse() when
parsing an IPv6 literal address.

Solution : 
	http://www.vuxml.org/freebsd/4d49f4ba-071f-11d9-b45d-000c41e2cdad.html
	http://www.vuxml.org/freebsd/762d1c6d-0722-11d9-b45d-000c41e2cdad.html	
	
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the apache package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^apache-2", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"apache-2.0.48_4") < 0 ) 
	security_hole(0);
