#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12525);
 script_bugtraq_id(9826);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0113");
 name["english"] = "FreeBSD Ports : Apache <= 2.0.48_3";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the Apache 2.0 package which is
older than 2.0.48_3.

There is a security issue in mod_ssl which may allow a denial of
service attack against an SSL-enabled server. An attacker could abuse
this problem to disable the remote web server (if enabled with https)
remotely.

Solution : http://www.vuxml.org/freebsd/492f8896-70fa-11d8-873f-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the apache package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^apache-2", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"apache-2.0.48_4") < 0 ) 
	security_hole(0);
