#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15509);
 script_bugtraq_id(10736);
 script_cve_id("CAN-2004-0700");
 script_version ("$Revision: 1.1 $");
 name["english"] = "FreeBSD Ports : Apache+SSL < 1.3.31+2.8.19";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the apache+ssl package which
is older than 1.3.29+2.8.19

Apache is a popular web server. There is a format string vulnerability in the
remote version of this software which may allow an attacker to execute 
arbitrary code on the remote host is the remote Apache server is used as a proxy
for HTTPS URLs.

Solution : http://www.vuxml.org/freebsd/18974c8a-1fbd-11d9-814e-0001020eed82.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the apache+ssl package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^apache\+ssl", string:pkgs);
if ( ! package ) exit(0);
if ( pkg_cmp(pkg:package, reference:"apache+ssl-1.3.31+2.8.19") < 0 ) 
	security_hole(0);


