#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12524);
 script_version ("$Revision: 1.2 $");
 name["english"] = "FreeBSD Ports : Apache+SSL < 1.3.29.1.53";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the apache+ssl package which
is older than 1.3.29.1.53.

Apache is a popular web server. There is a bug in the remote version of
this software which may allow a client to use real basic authentication to
forge a client certificate.

Solution : http://www.vuxml.org/freebsd/7557a2b1-5d63-11d8-80e3-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the apache+ssl package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^apache\+ssl", string:pkgs);
if ( ! package ) exit(0);
if ( pkg_cmp(pkg:package, reference:"apache+ssl-1.3.29.1.53") < 0 ) 
	security_hole(0);


